/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.block.BaseTileEntity;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EntangledBlockTile
extends BaseTileEntity
implements ITickableTileEntity {
    private boolean bound = false;
    private BlockPos pos;
    private RegistryKey<World> dimension;
    private BlockState blockState;
    private final int[] redstoneSignal = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] directRedstoneSignal = new int[]{0, 0, 0, 0, 0, 0};
    private int analogOutputSignal = -1;
    private int callDepth = 0;

    public EntangledBlockTile() {
        super(Entangled.tile);
    }

    public void func_73660_a() {
        World world;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.bound && this.pos != null && (world = this.getDimension()) != null && (world.isAreaLoaded(this.pos, 1) || this.blockState == null || this.analogOutputSignal == -1)) {
            BlockState state = world.func_180495_p(this.pos);
            int analogOutputSignal = state.func_185912_n() ? state.func_185888_a(world, this.pos) : 0;
            boolean signalChanged = false;
            for (Direction direction : Direction.values()) {
                int redstoneSignal = state.func_185911_a((IBlockReader)world, this.pos, direction);
                int directRedstoneSignal = state.func_185893_b((IBlockReader)world, this.pos, direction);
                if (redstoneSignal == this.redstoneSignal[direction.func_176745_a()] && directRedstoneSignal == this.directRedstoneSignal[direction.func_176745_a()]) continue;
                signalChanged = true;
                this.redstoneSignal[direction.func_176745_a()] = redstoneSignal;
                this.directRedstoneSignal[direction.func_176745_a()] = directRedstoneSignal;
            }
            if (state != this.blockState || analogOutputSignal != this.analogOutputSignal || signalChanged) {
                this.blockState = state;
                this.analogOutputSignal = analogOutputSignal;
                this.dataChanged();
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
                this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
            }
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    @Nullable
    public BlockPos getBoundBlockPos() {
        return this.pos;
    }

    public RegistryKey<World> getBoundDimension() {
        return this.dimension;
    }

    public BlockState getBoundBlockState() {
        return this.blockState;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability) {
        if (this.field_145850_b == null) {
            return LazyOptional.empty();
        }
        if (this.bound) {
            TileEntity tile;
            if (this.field_145850_b.field_72995_K && this.field_145850_b.func_234923_W_() != this.dimension || this.callDepth >= 10) {
                return LazyOptional.empty();
            }
            World world = this.getDimension();
            if (world != null && (tile = world.func_175625_s(this.pos)) != null) {
                ++this.callDepth;
                LazyOptional value = tile.getCapability(capability);
                --this.callDepth;
                return value;
            }
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (this.field_145850_b == null) {
            return LazyOptional.empty();
        }
        if (this.bound) {
            TileEntity tile;
            if (this.field_145850_b.field_72995_K && this.field_145850_b.func_234923_W_() != this.dimension || this.callDepth >= 10) {
                return LazyOptional.empty();
            }
            World world = this.getDimension();
            if (world != null && (tile = world.func_175625_s(this.pos)) != null) {
                ++this.callDepth;
                LazyOptional value = tile.getCapability(capability, facing);
                --this.callDepth;
                return value;
            }
        }
        return LazyOptional.empty();
    }

    public boolean bind(BlockPos pos, String dimension) {
        if (!this.canBindTo(pos, dimension)) {
            return false;
        }
        this.pos = pos == null ? null : new BlockPos((Vector3i)pos);
        this.dimension = dimension == null ? null : RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(dimension));
        this.bound = pos != null;
        this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
        this.dataChanged();
        return true;
    }

    public boolean canBindTo(BlockPos pos, String dimension) {
        return pos == null && dimension == null || dimension.equals(this.field_145850_b.func_234923_W_().func_240901_a_().toString()) ? EntangledConfig.maxDistance.get() == -1 || this.field_174879_c.func_218141_a((Vector3i)pos, (double)EntangledConfig.maxDistance.get().intValue() + 0.5) : EntangledConfig.allowDimensional.get();
    }

    private World getDimension() {
        if (this.dimension == null) {
            return null;
        }
        return this.field_145850_b.field_72995_K ? (this.field_145850_b.func_234923_W_() == this.dimension ? this.field_145850_b : null) : this.field_145850_b.func_73046_m().func_71218_a(this.dimension);
    }

    private boolean isTargetLoaded() {
        if (this.field_145850_b.field_72995_K || !this.bound) {
            return false;
        }
        World world = this.field_145850_b.func_234923_W_() == this.dimension ? this.field_145850_b : this.field_145850_b.func_73046_m().func_71218_a(this.dimension);
        return world != null && world.func_195588_v(this.pos);
    }

    public int getRedstoneSignal(Direction side) {
        if (!this.bound) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            World world = this.getDimension();
            this.redstoneSignal[side.func_176745_a()] = world.func_180495_p(this.pos).func_185911_a((IBlockReader)world, this.pos, side);
            --this.callDepth;
            return Math.max(this.redstoneSignal[side.func_176745_a()], 0);
        }
        return Math.max(this.redstoneSignal[side.func_176745_a()], 0);
    }

    public int getDirectRedstoneSignal(Direction side) {
        if (!this.bound) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            World world = this.getDimension();
            this.directRedstoneSignal[side.func_176745_a()] = world.func_180495_p(this.pos).func_185893_b((IBlockReader)world, this.pos, side);
            --this.callDepth;
            return Math.max(this.directRedstoneSignal[side.func_176745_a()], 0);
        }
        return Math.max(this.directRedstoneSignal[side.func_176745_a()], 0);
    }

    public int getAnalogOutputSignal() {
        if (!this.bound) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            World world = this.getDimension();
            this.analogOutputSignal = world.func_180495_p(this.pos).func_185888_a(world, this.pos);
            --this.callDepth;
            return Math.max(this.analogOutputSignal, 0);
        }
        return Math.max(this.analogOutputSignal, 0);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("bound")) {
            CompoundNBT data = new CompoundNBT();
            data.func_74757_a("bound", compound.func_74767_n("bound"));
            data.func_74768_a("boundx", compound.func_74762_e("boundx"));
            data.func_74768_a("boundy", compound.func_74762_e("boundy"));
            data.func_74768_a("boundz", compound.func_74762_e("boundz"));
            data.func_74778_a("dimension", compound.func_74779_i("dimension"));
            compound.func_218657_a("data", (INBT)data);
        }
        super.func_230337_a_(state, compound);
    }

    protected CompoundNBT writeData() {
        CompoundNBT compound = new CompoundNBT();
        if (this.bound) {
            compound.func_74757_a("bound", true);
            compound.func_74768_a("boundx", this.pos.func_177958_n());
            compound.func_74768_a("boundy", this.pos.func_177956_o());
            compound.func_74768_a("boundz", this.pos.func_177952_p());
            compound.func_74778_a("dimension", this.dimension.func_240901_a_().toString());
            compound.func_74768_a("blockstate", Block.func_196246_j((BlockState)this.blockState));
            for (Direction direction : Direction.values()) {
                int index = direction.func_176745_a();
                compound.func_74768_a("redstoneSignal" + index, this.redstoneSignal[index]);
                compound.func_74768_a("directRedstoneSignal" + index, this.directRedstoneSignal[index]);
            }
            compound.func_74768_a("analogOutputSignal", this.analogOutputSignal);
        }
        return compound;
    }

    protected void readData(CompoundNBT compound) {
        this.bound = compound.func_74767_n("bound");
        if (this.bound) {
            this.pos = new BlockPos(compound.func_74762_e("boundx"), compound.func_74762_e("boundy"), compound.func_74762_e("boundz"));
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("dimension")));
            this.blockState = Block.func_196257_b((int)compound.func_74762_e("blockstate"));
            for (Direction direction : Direction.values()) {
                int index = direction.func_176745_a();
                this.redstoneSignal[index] = compound.func_74762_e("redstoneSignal" + index);
                this.directRedstoneSignal[index] = compound.func_74762_e("directRedstoneSignal" + index);
            }
            this.analogOutputSignal = compound.func_74762_e("analogOutputSignal");
        }
    }
}

