/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.event;

import cofh.ensorcellation.enchantment.DisplacementEnchantment;
import cofh.ensorcellation.enchantment.FireRebukeEnchantment;
import cofh.ensorcellation.enchantment.FrostRebukeEnchantment;
import cofh.ensorcellation.enchantment.override.ThornsEnchantmentImp;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.references.EnsorcReferences;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.ThornsEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ensorcellation")
public class ShieldEnchEvents {
    private ShieldEnchEvents() {
    }

    @SubscribeEvent
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        ItemStack stack = entity.func_184607_cu();
        if (ShieldEnchEvents.canBlockDamageSource(entity, source) && attacker != null) {
            PlayerEntity playerAttacker;
            int encBulwark;
            int encFrostRebuke;
            int encFireRebuke;
            int encDisplacement;
            int encThorns = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.field_92091_k, (ItemStack)stack);
            if (ThornsEnchantmentImp.shouldHit(encThorns, entity.func_70681_au())) {
                attacker.func_70097_a(DamageSource.func_92087_a((Entity)entity), (float)ThornsEnchantment.func_92095_b((int)encThorns, (Random)entity.func_70681_au()));
            }
            if (DisplacementEnchantment.shouldHit(encDisplacement = Utils.getItemEnchantmentLevel((Enchantment)EnsorcReferences.DISPLACEMENT, (ItemStack)stack), entity.func_70681_au())) {
                DisplacementEnchantment.onHit(entity, attacker, encDisplacement);
            }
            if (FireRebukeEnchantment.shouldHit(encFireRebuke = Utils.getItemEnchantmentLevel((Enchantment)EnsorcReferences.FIRE_REBUKE, (ItemStack)stack), entity.func_70681_au())) {
                FireRebukeEnchantment.onHit(entity, attacker, encFireRebuke);
            }
            if (FrostRebukeEnchantment.shouldHit(encFrostRebuke = Utils.getItemEnchantmentLevel((Enchantment)EnsorcReferences.FROST_REBUKE, (ItemStack)stack), entity.func_70681_au())) {
                FrostRebukeEnchantment.onHit(entity, attacker, encFrostRebuke);
            }
            if ((encBulwark = Utils.getItemEnchantmentLevel((Enchantment)EnsorcReferences.BULWARK, (ItemStack)stack)) > 0 && attacker instanceof PlayerEntity && (playerAttacker = (PlayerEntity)attacker).func_70681_au().nextFloat() < 0.5f) {
                playerAttacker.func_184811_cZ().func_185145_a(playerAttacker.func_184614_ca().func_77973_b(), 100);
                attacker.field_70170_p.func_72960_a(attacker, (byte)30);
            }
        }
    }

    @SubscribeEvent
    public static void handleLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        ItemStack stack = entity.func_184607_cu();
        ModifiableAttributeInstance knockbackResAttr = entity.func_110148_a(Attributes.field_233820_c_);
        ModifiableAttributeInstance moveSpeedAttr = entity.func_110148_a(Attributes.field_233821_d_);
        if (knockbackResAttr != null) {
            knockbackResAttr.func_188479_b(Constants.UUID_ENCH_BULWARK_KNOCKBACK_RESISTANCE);
        }
        if (moveSpeedAttr != null) {
            moveSpeedAttr.func_188479_b(Constants.UUID_ENCH_PHALANX_MOVEMENT_SPEED);
        }
        if (stack.func_77973_b().isShield(stack, entity)) {
            int encBulwark = Utils.getItemEnchantmentLevel((Enchantment)EnsorcReferences.BULWARK, (ItemStack)stack);
            if (knockbackResAttr != null && encBulwark > 0) {
                knockbackResAttr.func_233767_b_(new AttributeModifier(Constants.UUID_ENCH_BULWARK_KNOCKBACK_RESISTANCE, "bulwark", 1.0, AttributeModifier.Operation.ADDITION));
            }
            int encPhalanx = Utils.getItemEnchantmentLevel((Enchantment)EnsorcReferences.PHALANX, (ItemStack)stack);
            if (moveSpeedAttr != null && encPhalanx > 0) {
                moveSpeedAttr.func_233767_b_(new AttributeModifier(Constants.UUID_ENCH_PHALANX_MOVEMENT_SPEED, "phalanx", 1.25 * (double)encPhalanx, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }
    }

    private static boolean canBlockDamageSource(LivingEntity living, DamageSource source) {
        Vector3d vec3d2;
        AbstractArrowEntity arrow;
        Entity entity = source.func_76364_f();
        if (entity instanceof AbstractArrowEntity && (arrow = (AbstractArrowEntity)entity).func_213874_s() > 0) {
            return false;
        }
        if (!source.func_76363_c() && living.func_184585_cz() && (vec3d2 = source.func_188404_v()) != null) {
            Vector3d vec3d = living.func_70676_i(1.0f);
            Vector3d vec3d1 = vec3d2.func_72444_a(new Vector3d(living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_())).func_72432_b();
            vec3d1 = new Vector3d(vec3d1.field_72450_a, 0.0, vec3d1.field_72449_c);
            return vec3d1.func_72430_b(vec3d) < 0.0;
        }
        return false;
    }
}

