/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.items;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wile.engineerstools.ModEngineersTools;
import wile.engineerstools.detail.ModResources;
import wile.engineerstools.items.EtItem;

public class AutoStimPackItem
extends EtItem {
    private static int max_uses = 2;
    private static float trigger_threshold_health = 3.0f;
    private static float instant_healing_health = 3.0f;

    public static void on_config(int maxuses, int trigger_threshold_hearts, int instant_healing_hearts) {
        max_uses = MathHelper.func_76125_a((int)maxuses, (int)1, (int)3);
        trigger_threshold_health = MathHelper.func_76125_a((int)trigger_threshold_hearts, (int)2, (int)5);
        instant_healing_health = MathHelper.func_76125_a((int)instant_healing_hearts, (int)1, (int)5);
        ModEngineersTools.LOGGER.info("Stimpack config: uses:" + max_uses + ", trigger:" + trigger_threshold_health + " hearts, inst-heal:" + instant_healing_health + " hearts.");
    }

    public AutoStimPackItem(Item.Properties properties) {
        super(properties.func_200917_a(1).func_200915_b(2).setNoRepair());
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof PlayerEntity) {
            this.inventoryTick(stack, world, (PlayerEntity)entity, itemSlot);
        }
    }

    private void inventoryTick(ItemStack stimpack, World world, PlayerEntity player, int itemSlot) {
        CompoundNBT nbt = stimpack.func_196082_o();
        if (nbt.func_74764_b("cd")) {
            int t;
            if (nbt.func_74764_b("ta")) {
                nbt.func_82580_o("ta");
            }
            if ((t = nbt.func_74762_e("cd")) > 0) {
                nbt.func_74768_a("cd", t - 1);
            } else {
                nbt.func_82580_o("cd");
                if (nbt.func_186856_d() == 0) {
                    nbt = null;
                }
            }
        } else {
            float health = player.func_110143_aJ();
            if (health > trigger_threshold_health * 2.0f || !player.func_70089_S()) {
                return;
            }
            int t = nbt.func_74762_e("ta");
            if (t < 20) {
                if (t == 2) {
                    world.func_184133_a(player, player.func_233580_cy_(), ModResources.STIMPACK_INJECT_SOUND, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                nbt.func_74768_a("ta", t + 1);
            } else {
                nbt.func_82580_o("ta");
                if (!world.field_72995_K) {
                    int dmg = stimpack.func_77952_i() + 1;
                    if (dmg >= stimpack.func_77958_k()) {
                        stimpack.func_190918_g(1);
                    } else {
                        stimpack.func_196085_b(dmg);
                    }
                    player.func_70606_j(health + instant_healing_health * 2.0f);
                    player.func_195064_c(new EffectInstance(Effects.field_76424_c, 400));
                    player.func_195064_c(new EffectInstance(Effects.field_76428_l, 300));
                    player.func_195064_c(new EffectInstance(Effects.field_76429_m, 200));
                    player.func_195064_c(new EffectInstance(Effects.field_76426_n, 200));
                }
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack other;
                if (i == itemSlot || !(other = player.field_71071_by.func_70301_a(i)).func_185136_b(stimpack)) continue;
                CompoundNBT other_nbt = other.func_196082_o();
                other_nbt.func_82580_o("ta");
                other_nbt.func_74768_a("cd", 30);
            }
            nbt.func_82580_o("cd");
            if (nbt.func_186856_d() == 0) {
                nbt = null;
            }
            if (!world.field_72995_K) {
                player.field_71071_by.func_70296_d();
            }
        }
        stimpack.func_77982_d(nbt);
    }
}

