/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools;

import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import wile.engineerstools.ModContent;
import wile.engineerstools.ModEngineersTools;
import wile.engineerstools.blocks.AriadneCoalBlock;
import wile.engineerstools.items.AutoStimPackItem;
import wile.engineerstools.items.DivingCapsuleItem;
import wile.engineerstools.items.ModBlockItem;
import wile.engineerstools.items.MusliBarItem;
import wile.engineerstools.items.MusliBarPressItem;
import wile.engineerstools.items.RediaToolItem;
import wile.engineerstools.libmc.detail.Auxiliaries;
import wile.engineerstools.libmc.detail.LootTableExtension;
import wile.engineerstools.libmc.detail.OptionalRecipeCondition;

public class ModConfig {
    private static final Logger LOGGER = ModEngineersTools.LOGGER;
    private static final String MODID = "engineerstools";
    public static final CommonConfig COMMON;
    public static final ServerConfig SERVER;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    public static final ForgeConfigSpec SERVER_CONFIG_SPEC;
    public static final ForgeConfigSpec CLIENT_CONFIG_SPEC;
    private static final CompoundNBT server_config_;
    private static HashSet<String> optouts_;
    private static boolean with_experimental_features_;
    private static boolean with_config_logging_;
    public static boolean immersiveengineering_installed;

    public static void onLoad(net.minecraftforge.fml.config.ModConfig config) {
        try {
            LOGGER.info("Loading config file {}", (Object)config.getFileName());
            ModConfig.apply();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to apply config file data {}", (Object)config.getFileName());
        }
    }

    public static void onFileChange(net.minecraftforge.fml.config.ModConfig config) {
        try {
            LOGGER.info("Config file changed {}", (Object)config.getFileName());
            ModConfig.apply();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to apply config file data {}", (Object)config.getFileName());
        }
    }

    public static final boolean isOptedOut(@Nullable Block block) {
        return ModConfig.isOptedOut(block.func_199767_j());
    }

    public static final boolean isOptedOut(@Nullable Item item) {
        return item != null && optouts_.contains(item.getRegistryName().func_110623_a());
    }

    public static boolean withExperimental() {
        return with_experimental_features_;
    }

    public static boolean withoutRecipes() {
        return false;
    }

    public static final CompoundNBT getServerConfig() {
        return server_config_;
    }

    private static final void updateOptouts() {
        int i;
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        String inc = ((String)ModConfig.COMMON.pattern_includes.get()).toLowerCase().replaceAll("engineerstools:", "").replaceAll("[^*_,a-z0-9]", "");
        if (ModConfig.COMMON.pattern_includes.get() != inc) {
            ModConfig.COMMON.pattern_includes.set((Object)inc);
        }
        String[] incl = inc.split(",");
        for (i = 0; i < incl.length; ++i) {
            incl[i] = incl[i].replaceAll("[*]", ".*?");
            if (incl[i].isEmpty()) continue;
            includes.add(incl[i]);
        }
        String exc = ((String)ModConfig.COMMON.pattern_excludes.get()).toLowerCase().replaceAll("engineerstools:", "").replaceAll("[^*_,a-z0-9]", "");
        String[] excl = exc.split(",");
        for (i = 0; i < excl.length; ++i) {
            excl[i] = excl[i].replaceAll("[*]", ".*?");
            if (excl[i].isEmpty()) continue;
            excludes.add(excl[i]);
        }
        if (!excludes.isEmpty()) {
            ModConfig.log("Config pattern excludes: '" + String.join((CharSequence)",", excludes) + "'");
        }
        if (!includes.isEmpty()) {
            ModConfig.log("Config pattern includes: '" + String.join((CharSequence)",", includes) + "'");
        }
        HashSet optouts = new HashSet();
        ModContent.getRegisteredItems().stream().filter(item -> {
            if (item == null) {
                return true;
            }
            if (item instanceof ModBlockItem && ((ModBlockItem)((Object)item)).func_179223_d() instanceof AriadneCoalBlock) {
                return true;
            }
            try {
                String rn = item.getRegistryName().func_110623_a();
                try {
                    for (String e : includes) {
                        if (!rn.matches(e)) continue;
                        return false;
                    }
                    for (String e : excludes) {
                        if (!rn.matches(e)) continue;
                        return true;
                    }
                }
                catch (Throwable ex) {
                    LOGGER.error("optout include pattern failed, disabling.");
                    includes.clear();
                    excludes.clear();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Exception evaluating the optout config: '" + ex.getMessage() + "'");
            }
            return false;
        }).forEach(e -> optouts.add(e.getRegistryName().func_110623_a()));
        ModContent.getRegisteredBlocks().stream().filter(e -> e == null || ModConfig.isOptedOut(e.func_199767_j())).forEach(e -> optouts.add(e.getRegistryName().func_110623_a()));
        optouts_ = optouts;
        String s = String.join((CharSequence)",", optouts_);
        server_config_.func_74778_a("optout", s);
        if (!s.isEmpty()) {
            ModConfig.log("Opt-outs:" + s);
        }
        OptionalRecipeCondition.on_config(ModConfig.withExperimental(), ModConfig.withoutRecipes(), block -> ModConfig.isOptedOut(block), item -> ModConfig.isOptedOut(item));
    }

    public static final void apply() {
        with_config_logging_ = (Boolean)ModConfig.COMMON.with_config_logging.get();
        with_experimental_features_ = (Boolean)ModConfig.COMMON.with_experimental.get();
        LootTableExtension.enabled = (Boolean)ModConfig.COMMON.with_chest_loot.get();
        if (with_experimental_features_) {
            LOGGER.info("Config: EXPERIMENTAL FEATURES ENABLED.");
        }
        immersiveengineering_installed = Auxiliaries.isModLoaded("immersiveengineering");
        if (with_config_logging_) {
            if (immersiveengineering_installed) {
                LOGGER.info("Immersive Engineering also installed.");
            }
            LOGGER.info("Chest loot generation: " + (LootTableExtension.enabled ? "enabled" : "disabled") + ".");
        }
        ModConfig.updateOptouts();
        if (!SERVER_CONFIG_SPEC.isLoaded()) {
            return;
        }
        if (((String)ModConfig.SERVER.redia_tool_efficiency_curve.get()).equals("10,60,90,100,120,140,170,200,220,230")) {
            ModConfig.SERVER.redia_tool_efficiency_curve.set((Object)"0,1,1,2,2,3,3,3,3,4");
        }
        RediaToolItem.on_config(false, false, false, (Integer)ModConfig.SERVER.redia_tool_durability.get(), (String)ModConfig.SERVER.redia_tool_efficiency_curve.get(), (String)ModConfig.SERVER.redia_tool_furtune_curve.get(), (Integer)ModConfig.SERVER.redia_tool_initial_durability_percent.get(), (Boolean)ModConfig.SERVER.without_safe_attacking.get());
        AutoStimPackItem.on_config(2, 3, 3);
        DivingCapsuleItem.on_config(10, 3, 7);
        MusliBarItem.on_config(6, 1.2);
        MusliBarPressItem.on_config(512, 128, 1, 8);
    }

    public static final void log(String config_message) {
        if (!with_config_logging_) {
            return;
        }
        LOGGER.info(config_message);
    }

    static {
        Pair common_ = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)common_.getRight();
        COMMON = (CommonConfig)common_.getLeft();
        Pair server_ = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_CONFIG_SPEC = (ForgeConfigSpec)server_.getRight();
        SERVER = (ServerConfig)server_.getLeft();
        Pair client_ = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_CONFIG_SPEC = (ForgeConfigSpec)client_.getRight();
        CLIENT = (ClientConfig)client_.getLeft();
        server_config_ = new CompoundNBT();
        optouts_ = new HashSet();
        with_experimental_features_ = false;
        with_config_logging_ = false;
        immersiveengineering_installed = false;
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.IntValue redia_tool_durability;
        public final ForgeConfigSpec.IntValue redia_tool_initial_durability_percent;
        public final ForgeConfigSpec.ConfigValue<String> redia_tool_efficiency_curve;
        public final ForgeConfigSpec.ConfigValue<String> redia_tool_furtune_curve;
        public final ForgeConfigSpec.BooleanValue without_safe_attacking;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side, also valid for single player games.").push("server");
            builder.comment("Settings to tweak the performance, or use cases normally no change should be required here.").push("tweaks");
            this.redia_tool_durability = builder.translation("engineerstools.config.redia_tool_durability").comment("Durability (maximum item damage) of the REDIA tool.").defineInRange("redia_tool_durability", 3000, 750, 4000);
            this.redia_tool_initial_durability_percent = builder.translation("engineerstools.config.redia_tool_initial_durability_percent").comment("Durability of the REDIA tool in percent, which the tool has when it is crafted. Allows to tune initial repairing investments for getting efficiency and furtune.").defineInRange("redia_tool_initial_durability_percent", 100, 50, 100);
            this.redia_tool_efficiency_curve = builder.translation("engineerstools.config.redia_tool_efficiency_curve").comment("Defines the efficiency scaling depending on the durability. Ten values have to given as integer numbers, (between 0 and 4), and the curve must be rising left-to-right. 0 corresponds to vanilla diamond tools. The first number specifies the efficiency between 0% and 10% durability, second 10% to 20%, last 90% to 100%.").define("redia_tool_efficiency_curve", (Object)"0,1,1,2,2,3,3,3,3,4");
            this.redia_tool_furtune_curve = builder.translation("engineerstools.config.redia_tool_furtune_curve").comment("Defines the fortune depending on the durability. Ten values have to given as integer numbers, (between 0 and 3), and the curve must be rising left-to-right. The first number specifies the furtune between 0% and 10% durability, second 10% to 20%, last 90% to 100%.").define("redia_tool_furtune_curve", (Object)"0,0,0,0,1,1,1,1,2,3");
            this.without_safe_attacking = builder.translation("engineerstools.config.without_safe_attacking").comment("Disable the REDIA tool feature to prevent accidentally hitting own pets, villagers, or bloody zombie pigmen.").define("without_safe_attacking", false);
            builder.pop();
        }
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<String> pattern_excludes;
        public final ForgeConfigSpec.ConfigValue<String> pattern_includes;
        public final ForgeConfigSpec.BooleanValue with_experimental;
        public final ForgeConfigSpec.BooleanValue with_config_logging;
        public final ForgeConfigSpec.BooleanValue with_chest_loot;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side.").push("server");
            builder.comment("Opt-out settings").push("optout");
            this.pattern_excludes = builder.translation("engineerstools.config.pattern_excludes").comment("Opt-out any block by its registry name ('*' wildcard matching, comma separated list, whitespaces ignored. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' excludes everything that has 'wood' or 'steel' in the registry name. The matching result is also traced in the log file. ").define("pattern_excludes", (Object)"");
            this.pattern_includes = builder.translation("engineerstools.config.pattern_includes").comment("Prevent blocks from being opt'ed by registry name ('*' wildcard matching, comma separated list, whitespaces ignored. Evaluated before all other opt-out checks. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' includes everything that has 'wood' or 'steel' in the registry name.The matching result is also traced in the log file.").define("pattern_includes", (Object)"");
            builder.pop();
            builder.comment("Miscellaneous settings").push("miscellaneous");
            this.with_experimental = builder.translation("engineerstools.config.with_experimental").comment("Enables experimental features. Use at own risk.").define("with_experimental", false);
            this.with_config_logging = builder.translation("engineerstools.config.with_config_logging").comment("Enable detailed logging of the config values and resulting calculations in each mod feature config.").define("with_config_logging", false);
            this.with_chest_loot = builder.translation("engineerstools.config.with_chest_loot").comment("Enable chest loot tables for villages and mineshafts.").define("with_chest_loot", false);
            builder.pop();
        }
    }

    public static class ClientConfig {
        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings not loaded on servers.").push("client");
            builder.pop();
        }
    }
}

