/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.items;

import java.util.Optional;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import wile.engineerstools.items.EtItem;

public class SleepingBagItem
extends EtItem {
    public SleepingBagItem(Item.Properties properties) {
        super(properties.func_200917_a(1).func_200915_b(4096).setNoRepair());
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195991_k().func_180495_p(context.func_195995_a()).isBed((IBlockReader)context.func_195991_k(), context.func_195995_a(), (LivingEntity)context.func_195999_j())) {
            return ActionResultType.PASS;
        }
        this.onUse(context.func_195999_j(), context.func_195991_k(), context.func_195995_a(), context.func_196000_l());
        return context.func_195991_k().func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return ActionResultType.FAIL;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    private boolean onUse(PlayerEntity player, World world, BlockPos pos, Direction side) {
        if (side != Direction.UP) {
            return false;
        }
        PlayerEntity.SleepResult sr = this.trySleep(player, world, pos.func_177984_a(), true);
        if (sr == null) {
            return true;
        }
        if (sr == PlayerEntity.SleepResult.TOO_FAR_AWAY || sr.func_221259_a() == null) {
            return false;
        }
        if (!world.func_201670_d()) {
            player.func_146105_b(sr.func_221259_a(), true);
        }
        return false;
    }

    private PlayerEntity.SleepResult trySleep(PlayerEntity player, World world, BlockPos at, boolean set_spawn_point) {
        if (player.func_175149_v() || player.func_184812_l_()) {
            return null;
        }
        if (player.func_70608_bn()) {
            return null;
        }
        if (!player.func_70089_S()) {
            return PlayerEntity.SleepResult.OTHER_PROBLEM;
        }
        if (!world.func_230315_m_().func_236043_f_()) {
            return PlayerEntity.SleepResult.NOT_POSSIBLE_HERE;
        }
        double d0 = 8.0;
        double d1 = 5.0;
        if (!world.func_175647_a(MonsterEntity.class, new AxisAlignedBB((double)(at.func_177958_n() - 8), (double)(at.func_177956_o() - 5), (double)(at.func_177952_p() - 8), (double)(at.func_177958_n() + 8), (double)(at.func_177956_o() + 5), (double)(at.func_177952_p() + 8)), en -> en.func_230292_f_(player)).isEmpty()) {
            return PlayerEntity.SleepResult.NOT_SAFE;
        }
        if (!ForgeEventFactory.fireSleepingTimeCheck((PlayerEntity)player, Optional.of(at))) {
            return PlayerEntity.SleepResult.NOT_POSSIBLE_NOW;
        }
        if (world.func_201670_d() || !(player instanceof ServerPlayerEntity)) {
            return null;
        }
        ((ServerPlayerEntity)player).func_213369_d(at);
        Optional<BlockPos> optAt = Optional.of(at);
        PlayerEntity.SleepResult ret = ForgeEventFactory.onPlayerSleepInBed((PlayerEntity)player, optAt);
        if (ret != null) {
            return ret;
        }
        player.func_213342_e(at);
        ((ServerWorld)world).func_72854_c();
        return null;
    }

    public static void onSleepingLocationCheckEvent(SleepingLocationCheckEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (player.field_70170_p.field_72995_K || !(player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof SleepingBagItem)) {
            return;
        }
        event.setResult(Event.Result.ALLOW);
    }

    public static void onPlayerWakeUpEvent(PlayerWakeUpEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (player.field_70170_p.field_72995_K || !(player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof SleepingBagItem)) {
            return;
        }
    }
}

