/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.items;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import wile.engineerstools.ModContent;
import wile.engineerstools.items.EtItem;
import wile.engineerstools.libmc.detail.Auxiliaries;
import wile.engineerstools.libmc.detail.Inventories;
import wile.engineerstools.libmc.detail.Networking;

public class MaterialBoxItem
extends EtItem {
    private static boolean with_gui_mouse_handling = true;

    public static void on_config(boolean without_gui_mouse_handling, String item_blacklist) {
        with_gui_mouse_handling = !without_gui_mouse_handling;
        Auxiliaries.logInfo("Bag: " + (without_gui_mouse_handling ? "no-mouse-tweaks" : "") + (item_blacklist.isEmpty() ? "" : ", blacklist:'" + item_blacklist + "'"));
    }

    public MaterialBoxItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!Auxiliaries.Tooltip.extendedTipCondition() || Auxiliaries.Tooltip.helpCondition()) {
            super.func_77624_a(stack, world, tooltip, flag);
            return;
        }
        int num_used_slots = 0;
        HashMap<Item, Integer> stats = new HashMap<Item, Integer>();
        if (stack.func_77942_o()) {
            NonNullList<ItemStack> items = Inventories.readNbtStacks(stack.func_77978_p(), "stacks", 54);
            for (int i = 0; i < 54; ++i) {
                ItemStack st = (ItemStack)items.get(i);
                if (st.func_190926_b()) continue;
                stats.put(st.func_77973_b(), stats.getOrDefault(st.func_77973_b(), 0) + 1);
                ++num_used_slots;
            }
        }
        tooltip.add((ITextComponent)new StringTextComponent(Auxiliaries.localize(this.func_77658_a() + ".tip", num_used_slots, 54 - num_used_slots)));
        if (!stats.isEmpty()) {
            List elems = stats.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(e -> new TranslationTextComponent(((Item)e.getKey()).func_77658_a())).collect(Collectors.toList());
            Collections.reverse(elems);
            int MAX_TOOLTIP_ITEM_LINE_LENGTH = 40;
            int MAX_TOOLTIP_ITEMS = 20;
            StringTextComponent item_list = new StringTextComponent("");
            int slen = 0;
            if (!elems.isEmpty()) {
                tooltip.add((ITextComponent)new StringTextComponent(""));
                int nleft = 20;
                for (ITextComponent e2 : elems) {
                    if (--nleft < 0) break;
                    if (slen + e2.func_150261_e().length() > 40) {
                        tooltip.add((ITextComponent)item_list);
                        item_list = new StringTextComponent("");
                        slen = 0;
                    } else if (slen > 0) {
                        item_list.func_230529_a_((ITextComponent)new TranslationTextComponent(" | ")).func_240699_a_(TextFormatting.DARK_GRAY);
                    }
                    item_list.func_230529_a_((ITextComponent)(e2 instanceof IFormattableTextComponent ? ((IFormattableTextComponent)e2).func_240699_a_(TextFormatting.GRAY) : e2));
                    slen += e2.func_150261_e().length();
                }
                if (slen > 0) {
                    tooltip.add((ITextComponent)item_list);
                }
            }
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.func_201670_d()) {
            if (stack.func_190916_E() > 1) {
                world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187654_U, SoundCategory.NEUTRAL, 0.4f, 3.0f);
                return new ActionResult(ActionResultType.FAIL, (Object)stack);
            }
        } else if (stack.func_190916_E() == 1) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent(MaterialBoxItem.this.getRegistryName().toString());
                }

                public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                    return new MaterialBoxContainer(id, inventory, player);
                }
            });
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public int getItemStackLimit(ItemStack stack) {
        return stack.func_77942_o() ? 1 : this.func_77639_j();
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(World world, Entity oe, ItemStack stack) {
        boolean is_filled = stack.func_190916_E() == 1 && stack.func_77942_o();
        MaterialBoxEntity e = new MaterialBoxEntity(world, oe.func_226277_ct_(), oe.func_226278_cu_(), oe.func_226281_cx_(), stack);
        if (oe instanceof ItemEntity) {
            e.func_174869_p();
        }
        e.func_174810_b(true);
        e.func_213317_d(oe.func_213322_ci());
        if (oe instanceof ItemEntity) {
            e.func_200217_b(((ItemEntity)oe).func_200215_l());
            e.func_200216_c(((ItemEntity)oe).func_200214_m());
        }
        return e;
    }

    private static class MaterialBoxEntity
    extends ItemEntity {
        private final boolean filled = this.func_92059_d().func_190916_E() == 1 && this.func_92059_d().func_77942_o();

        public MaterialBoxEntity(World world, double x, double y, double z, ItemStack stack) {
            super(world, x, y, z, stack);
            this.func_184224_h(this.filled);
            this.lifespan = this.filled ? 72000 : 6000;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (!this.filled) {
                return super.func_70097_a(source, amount);
            }
            if (this.field_70170_p.field_72995_K || this.field_70128_L) {
                return false;
            }
            this.lifespan = Math.max(this.lifespan - 200, 200);
            return false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MaterialBoxGui
    extends ContainerScreen<MaterialBoxContainer> {
        private static final ResourceLocation BACKGROUND_IMAGE = new ResourceLocation(Auxiliaries.modid(), "textures/gui/material_box_gui.png");
        private final PlayerEntity player;

        public MaterialBoxGui(MaterialBoxContainer uicontainer, PlayerInventory player_inventory, ITextComponent title) {
            super((Container)uicontainer, player_inventory, title);
            this.player = player_inventory.field_70458_d;
            this.field_146999_f = 213;
            this.field_147000_g = 206;
        }

        public void func_230430_a_(MatrixStack mx, int mouseX, int mouseY, float partialTicks) {
            this.func_230446_a_(mx);
            super.func_230430_a_(mx, mouseX, mouseY, partialTicks);
            this.func_230459_a_(mx, mouseX, mouseY);
        }

        protected void func_230450_a_(MatrixStack mx, float partialTicks, int mouseX, int mouseY) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_IMAGE);
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            int w = this.getXSize();
            int h = this.getYSize();
            this.func_238474_b_(mx, x0, y0, 0, 0, w, h);
            MaterialBoxContainer.ReadonlySlot slot = ((MaterialBoxContainer)this.func_212873_a_()).bag_slot_;
            if (slot != null) {
                this.func_238474_b_(mx, x0 + slot.field_75223_e, y0 + slot.field_75221_f, 240, 183, 16, 16);
            }
        }

        protected void func_230451_b_(MatrixStack mx, int x, int y) {
        }

        protected void action(String message) {
            this.action(message, new CompoundNBT());
        }

        protected void action(String message, CompoundNBT nbt) {
            ((MaterialBoxContainer)this.func_212873_a_()).onGuiAction(message, nbt);
        }

        protected void func_184098_a(Slot slot, int slotId, int button, ClickType type) {
            if (type == ClickType.SWAP) {
                return;
            }
            if (!with_gui_mouse_handling) {
                super.func_184098_a(slot, slotId, button, type);
            } else if (type == ClickType.QUICK_MOVE && slot != null && slot.func_75216_d() && Auxiliaries.isShiftDown() && Auxiliaries.isCtrlDown()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a("slot", slotId);
                this.action("quick-move-all", nbt);
            } else {
                super.func_184098_a(slot, slotId, button, type);
            }
        }

        public boolean func_231043_a_(double mouseX, double mouseY, double wheel_inc) {
            if (!with_gui_mouse_handling) {
                return super.func_231043_a_(mouseX, mouseY, wheel_inc);
            }
            Slot slot = this.getSlotUnderMouse();
            if (!slot.func_75216_d()) {
                return true;
            }
            int count = slot.func_75211_c().func_190916_E();
            int limit = (Auxiliaries.isShiftDown() ? 2 : 1) * (Auxiliaries.isCtrlDown() ? 4 : 1);
            if (wheel_inc > 0.1) {
                if (count > 0 && count < slot.func_75211_c().func_77976_d() && count < slot.func_75219_a()) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_74768_a("slot", slot.field_75222_d);
                    if (limit > 1) {
                        nbt.func_74768_a("limit", limit);
                    }
                    this.action("increase-stack", nbt);
                }
            } else if (wheel_inc < -0.1 && count > 0) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a("slot", slot.field_75222_d);
                if (limit > 1) {
                    nbt.func_74768_a("limit", limit);
                }
                this.action("decrease-stack", nbt);
            }
            return true;
        }
    }

    public static class MaterialBoxContainer
    extends Container
    implements Networking.INetworkSynchronisableContainer {
        protected static final int NUM_OF_STORGE_SLOTS = 54;
        protected static final int STORAGE_SLOT_BEGIN = 0;
        protected static final int STORAGE_SLOT_END = 54;
        protected static final int PLAYER_SLOT_BEGIN = 54;
        protected static final int PLAYER_SLOT_END = 90;
        protected static final String QUICK_MOVE_ALL = "quick-move-all";
        protected static final String INCREASE_STACK = "increase-stack";
        protected static final String DECREASE_STACK = "decrease-stack";
        private PlayerEntity player;
        private PlayerInventory player_inventory;
        private StorageInventory inventory_ = new StorageInventory(54);
        private final ItemStack bag;
        private final Inventories.SlotRange player_slot_range;
        private final Inventories.SlotRange storage_slot_range;
        private ReadonlySlot bag_slot_ = null;

        private static boolean is_filled_box(ItemStack stack) {
            return stack.func_77973_b() instanceof MaterialBoxItem && stack.func_77942_o();
        }

        public MaterialBoxContainer(int cid, PlayerInventory player_inventory) {
            this(cid, player_inventory, player_inventory.field_70458_d);
        }

        public MaterialBoxContainer(int cid, PlayerInventory player_inventory, PlayerEntity player) {
            super(ModContent.CT_MATERIAL_BAG, cid);
            int x;
            int y;
            this.player_inventory = player_inventory;
            this.player = player;
            this.storage_slot_range = new Inventories.SlotRange((IInventory)this.inventory_, 0, 54);
            this.player_slot_range = new Inventories.SlotRange((IInventory)player_inventory, 0, 36);
            if (player_inventory.field_70461_c < 0 || player_inventory.field_70461_c >= player_inventory.func_70302_i_() || !(player_inventory.func_70301_a(player_inventory.field_70461_c).func_77973_b() instanceof MaterialBoxItem)) {
                this.bag = new ItemStack((IItemProvider)Items.field_190931_a);
                return;
            }
            this.bag = player_inventory.func_70301_a(player_inventory.field_70461_c);
            int i = -1;
            for (y = 0; y < 6; ++y) {
                for (x = 0; x < 9; ++x) {
                    int xpos = 28 + x * 18;
                    int ypos = 10 + y * 18;
                    this.func_75146_a(new StorageSlot(this, (IInventory)this.inventory_, ++i, xpos, ypos));
                }
            }
            for (int x2 = 0; x2 < 9; ++x2) {
                int slot = x2;
                if (player_inventory.field_70461_c != slot) {
                    this.func_75146_a(new PlayerSlot(this, (IInventory)player_inventory, slot, 28 + x2 * 18, 183));
                    continue;
                }
                this.bag_slot_ = new ReadonlySlot((IInventory)player_inventory, slot, 28 + x2 * 18, 183);
                this.func_75146_a(this.bag_slot_);
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    int slot = x + y * 9 + 9;
                    if (player_inventory.field_70461_c != slot) {
                        this.func_75146_a(new PlayerSlot(this, (IInventory)player_inventory, slot, 28 + x * 18, 125 + y * 18));
                        continue;
                    }
                    this.bag_slot_ = new ReadonlySlot((IInventory)player_inventory, slot, 28 + x * 18, 125 + y * 18);
                    this.func_75146_a(this.bag_slot_);
                }
            }
            this.read(this.bag.func_77978_p());
        }

        public boolean func_75145_c(PlayerEntity player) {
            return player == this.player;
        }

        public ItemStack func_82846_b(PlayerEntity player, int index) {
            Slot slot = this.func_75139_a(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index >= 0 && index < 54) {
                if (!this.func_75135_a(slot_stack, 54, 90, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 54 && index <= 90) {
                if (!this.func_75135_a(slot_stack, 0, 54, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }

        public void func_75134_a(PlayerEntity player) {
            super.func_75134_a(player);
            if (player.field_70170_p.func_201670_d()) {
                return;
            }
            CompoundNBT nbt = this.write(this.bag.func_77978_p());
            if (nbt != null && nbt.isEmpty()) {
                nbt = null;
            }
            this.bag.func_77982_d(nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String message, CompoundNBT nbt) {
            nbt.func_74778_a("action", message);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @Override
        public void onClientPacketReceived(int windowId, PlayerEntity player, CompoundNBT nbt) {
            int slotId;
            boolean changed = false;
            if (!nbt.func_74764_b("action")) {
                return;
            }
            int n = slotId = nbt.func_74764_b("slot") ? nbt.func_74762_e("slot") : -1;
            if (this.bag_slot_ != null && slotId == this.bag_slot_.field_75222_d) {
                return;
            }
            switch (nbt.func_74779_i("action")) {
                case "quick-move-all": {
                    if (slotId >= 0 && slotId < 54 && this.func_75139_a(slotId).func_75216_d()) {
                        Slot slot = this.func_75139_a(slotId);
                        ItemStack remaining = slot.func_75211_c();
                        slot.func_75215_d(ItemStack.field_190927_a);
                        ItemStack ref_stack = remaining.func_77946_l();
                        ref_stack.func_190920_e(ref_stack.func_77976_d());
                        for (int i = this.storage_slot_range.end_slot - this.storage_slot_range.start_slot; i > 0 && !remaining.func_190926_b() && (remaining = this.player_slot_range.insert(remaining, false, 0, true, true)).func_190926_b(); --i) {
                            remaining = this.storage_slot_range.extract(ref_stack);
                        }
                        if (!remaining.func_190926_b()) {
                            slot.func_75215_d(remaining);
                        }
                    } else if (slotId >= 54 && slotId < 90 && this.func_75139_a(slotId).func_75216_d()) {
                        Slot slot = this.func_75139_a(slotId);
                        ItemStack remaining = slot.func_75211_c();
                        slot.func_75215_d(ItemStack.field_190927_a);
                        ItemStack ref_stack = remaining.func_77946_l();
                        ref_stack.func_190920_e(ref_stack.func_77976_d());
                        for (int i = this.player_slot_range.end_slot - this.player_slot_range.start_slot; i > 0 && !remaining.func_190926_b() && (remaining = this.storage_slot_range.insert(remaining, false, 0, false, true)).func_190926_b(); --i) {
                            remaining = this.player_slot_range.extract(ref_stack);
                        }
                        if (!remaining.func_190926_b()) {
                            slot.func_75215_d(remaining);
                        }
                    }
                    changed = true;
                    break;
                }
                case "increase-stack": {
                    break;
                }
            }
            if (changed) {
                this.inventory_.func_70296_d();
                player.field_71071_by.func_70296_d();
                this.func_75142_b();
            }
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundNBT pkg_nbt) {
            if (!(this.bag.func_77973_b() instanceof MaterialBoxItem)) {
                return;
            }
            if (!pkg_nbt.func_74764_b("bag")) {
                return;
            }
            CompoundNBT nbt = pkg_nbt.func_74775_l("bag");
            this.read(nbt);
        }

        public CompoundNBT write(@Nullable CompoundNBT nbt) {
            NonNullList stacks = NonNullList.func_191196_a();
            for (int i = 0; i < this.inventory_.func_70302_i_(); ++i) {
                stacks.add((Object)this.inventory_.func_70301_a(i));
            }
            if (!stacks.stream().allMatch(ItemStack::func_190926_b)) {
                nbt = Inventories.writeNbtStacks(nbt, "stacks", (NonNullList<ItemStack>)stacks, true);
            } else if (nbt != null && nbt.func_74764_b("stacks")) {
                nbt.func_82580_o("stacks");
            }
            return nbt;
        }

        public CompoundNBT read(CompoundNBT nbt) {
            NonNullList<ItemStack> stacks = Inventories.readNbtStacks(nbt, "stacks", this.inventory_.func_70302_i_());
            for (int i = 0; i < this.inventory_.func_70302_i_(); ++i) {
                this.inventory_.func_70299_a(i, (ItemStack)stacks.get(i));
            }
            return nbt;
        }

        public void onSlotsChanged() {
            if (this.player.field_70170_p.func_201670_d()) {
                return;
            }
            CompoundNBT nbt = this.write(new CompoundNBT());
            this.bag.func_77982_d(nbt);
            this.player_inventory.func_70296_d();
            CompoundNBT pkg_nbt = new CompoundNBT();
            pkg_nbt.func_218657_a("bag", (INBT)nbt);
            Networking.PacketContainerSyncServerToClient.sendToPlayer(this.player, this.field_75152_c, pkg_nbt);
        }

        private static class StorageInventory
        extends Inventory {
            public StorageInventory(int nslots) {
                super(nslots);
            }

            public boolean func_94041_b(int index, ItemStack stack) {
                return !MaterialBoxContainer.is_filled_box(stack);
            }
        }

        private static class ReadonlySlot
        extends Slot {
            public ReadonlySlot(IInventory inventory, int index, int xpos, int ypos) {
                super(inventory, index, xpos, ypos);
            }

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_75209_a(int amount) {
                return ItemStack.field_190927_a;
            }

            public boolean func_82869_a(PlayerEntity player) {
                return false;
            }
        }

        private static class PlayerSlot
        extends Slot {
            private final MaterialBoxContainer uicontainer;

            public PlayerSlot(MaterialBoxContainer uicontainer, IInventory inventory, int index, int xpos, int ypos) {
                super(inventory, index, xpos, ypos);
                this.uicontainer = uicontainer;
            }

            public void func_75218_e() {
                this.field_75224_c.func_70296_d();
                this.uicontainer.onSlotsChanged();
            }
        }

        private static class StorageSlot
        extends Slot {
            private final MaterialBoxContainer uicontainer;

            public StorageSlot(MaterialBoxContainer uicontainer, IInventory inventory, int index, int xpos, int ypos) {
                super(inventory, index, xpos, ypos);
                this.uicontainer = uicontainer;
            }

            public boolean func_75214_a(ItemStack stack) {
                return !MaterialBoxContainer.is_filled_box(stack);
            }

            public void func_75218_e() {
                this.field_75224_c.func_70296_d();
                this.uicontainer.onSlotsChanged();
            }
        }
    }
}

