/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.EdCatwalkBlock;
import wile.engineersdecor.blocks.IDecorBlock;

public class EdCatwalkTopAlignedBlock
extends DecorBlock.WaterLoggable
implements IDecorBlock {
    public static final IntegerProperty VARIANT = IntegerProperty.func_177719_a((String)"variant", (int)0, (int)3);
    protected final List<VoxelShape> variant_shapes;

    public EdCatwalkTopAlignedBlock(long config, AbstractBlock.Properties properties, VoxelShape[] variant_shapes) {
        super(config, properties, variant_shapes[0]);
        this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)VARIANT, (Comparable)Integer.valueOf(0)));
        this.variant_shapes = VARIANT.func_177700_c().stream().map(i -> i < variant_shapes.length ? variant_shapes[i] : VoxelShapes.func_197868_b()).collect(Collectors.toList());
    }

    @Override
    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.variant_shapes.get((Integer)state.func_177229_b((Property)VARIANT));
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.func_220053_a(state, world, pos, selectionContext);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{VARIANT});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.adapted_state(super.func_196258_a(context), (IWorld)context.func_195991_k(), context.func_195995_a());
        if (context.func_196000_l() != Direction.UP) {
            return state;
        }
        BlockState below = context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b());
        if ((Integer)state.func_177229_b((Property)VARIANT) == 0 && below.func_224755_d((IBlockReader)context.func_195991_k(), context.func_195995_a().func_177977_b(), Direction.UP)) {
            return (BlockState)state.func_206870_a((Property)VARIANT, (Comparable)Integer.valueOf(3));
        }
        return state;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        Item item = player.func_184586_b(hand).func_77973_b();
        if (item != this.func_199767_j()) {
            return ActionResultType.PASS;
        }
        if (hit.func_216354_b().func_176740_k().func_176722_c()) {
            return ActionResultType.PASS;
        }
        BlockPos adjacent_pos = pos.func_177972_a(player.func_174811_aO());
        BlockState adjacent_state = world.func_180495_p(adjacent_pos);
        if (adjacent_state.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(world, adjacent_pos, hit.func_216354_b().func_176734_d(), player.func_184586_b(hand), hit.func_216354_b()))) {
            BlockState place_state = this.func_176223_P();
            place_state = (BlockState)place_state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(adjacent_state.func_204520_s().func_206886_c() == Fluids.field_204546_a));
            EdCatwalkBlock.place_consume(this.adapted_state(place_state, (IWorld)world, adjacent_pos), world, adjacent_pos, player, hand, 1);
        }
        return world.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return this.adapted_state(super.func_196271_a(state, facing, facingState, world, pos, facingPos), world, pos);
    }

    private BlockState adapted_state(BlockState state, IWorld world, BlockPos pos) {
        BlockState below = world.func_180495_p(pos.func_177977_b());
        if (below == null || state == null) {
            return state;
        }
        if (below.func_177230_c() == ModContent.THICK_STEEL_POLE || below.func_177230_c() == ModContent.THICK_STEEL_POLE_HEAD) {
            return (BlockState)state.func_206870_a((Property)VARIANT, (Comparable)Integer.valueOf(1));
        }
        if (below.func_177230_c() == ModContent.THIN_STEEL_POLE || below.func_177230_c() == ModContent.THIN_STEEL_POLE_HEAD) {
            return (BlockState)state.func_206870_a((Property)VARIANT, (Comparable)Integer.valueOf(2));
        }
        return state;
    }
}

