/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class StandardDoorBlock
extends DoorBlock
implements StandardBlocks.IStandardBlock {
    private final long config_;
    protected final VoxelShape[][][][] shapes_;
    protected final SoundEvent open_sound_;
    protected final SoundEvent close_sound_;

    public StandardDoorBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB[] open_aabbs_top, AxisAlignedBB[] open_aabbs_bottom, AxisAlignedBB[] closed_aabbs_top, AxisAlignedBB[] closed_aabbs_bottom, SoundEvent open_sound, SoundEvent close_sound) {
        super(properties);
        VoxelShape[][][][] shapes = new VoxelShape[Direction.values().length][2][2][2];
        for (Direction facing : Direction.values()) {
            for (boolean open : new boolean[]{false, true}) {
                for (DoubleBlockHalf half : new DoubleBlockHalf[]{DoubleBlockHalf.UPPER, DoubleBlockHalf.LOWER}) {
                    for (boolean hinge_right : new boolean[]{false, true}) {
                        VoxelShape shape = VoxelShapes.func_197880_a();
                        if (facing.func_176740_k() == Direction.Axis.Y) {
                            shape = VoxelShapes.func_197868_b();
                        } else {
                            AxisAlignedBB[] aabbs;
                            for (AxisAlignedBB e : aabbs = open ? (half == DoubleBlockHalf.UPPER ? open_aabbs_top : open_aabbs_bottom) : (half == DoubleBlockHalf.UPPER ? closed_aabbs_top : closed_aabbs_bottom)) {
                                AxisAlignedBB aabb = Auxiliaries.getRotatedAABB(e, facing, true);
                                if (!hinge_right) {
                                    aabb = Auxiliaries.getMirroredAABB(aabb, facing.func_176746_e().func_176740_k());
                                }
                                shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)aabb), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                            }
                        }
                        shapes[facing.ordinal()][open ? 1 : 0][hinge_right ? 1 : 0][half == DoubleBlockHalf.UPPER ? 0 : 1] = shape;
                    }
                }
            }
        }
        this.config_ = config;
        this.shapes_ = shapes;
        this.open_sound_ = open_sound;
        this.close_sound_ = close_sound;
    }

    public StandardDoorBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB open_aabb, AxisAlignedBB closed_aabb, SoundEvent open_sound, SoundEvent close_sound) {
        this(config, properties, new AxisAlignedBB[]{open_aabb}, new AxisAlignedBB[]{open_aabb}, new AxisAlignedBB[]{closed_aabb}, new AxisAlignedBB[]{closed_aabb}, open_sound, close_sound);
    }

    public StandardDoorBlock(long config, AbstractBlock.Properties properties, SoundEvent open_sound, SoundEvent close_sound) {
        this(config, properties, Auxiliaries.getPixeledAABB(13.0, 0.0, 0.0, 16.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 13.0, 16.0, 16.0, 16.0), open_sound, close_sound);
    }

    public StandardDoorBlock(long config, AbstractBlock.Properties properties) {
        this(config, properties, Auxiliaries.getPixeledAABB(13.0, 0.0, 0.0, 16.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 13.0, 16.0, 16.0, 16.0), SoundEvents.field_187875_gN, SoundEvents.field_187873_gM);
    }

    @Override
    public long config() {
        return this.config_;
    }

    protected void sound(IBlockReader world, BlockPos pos, boolean open) {
        if (world instanceof World) {
            ((World)world).func_184133_a(null, pos, open ? this.open_sound_ : this.close_sound_, SoundCategory.BLOCKS, 0.7f, 1.0f);
        }
    }

    protected void actuate_adjacent_wing(BlockState state, IBlockReader world_ro, BlockPos pos, boolean open) {
        if (!(world_ro instanceof World)) {
            return;
        }
        World world = (World)world_ro;
        BlockPos adjecent_pos = pos.func_177972_a(state.func_177229_b((Property)field_176521_M) == DoorHingeSide.LEFT ? ((Direction)state.func_177229_b((Property)field_176520_a)).func_176746_e() : ((Direction)state.func_177229_b((Property)field_176520_a)).func_176735_f());
        if (!world.func_195588_v(adjecent_pos)) {
            return;
        }
        BlockState adjacent_state = world.func_180495_p(adjecent_pos);
        if (adjacent_state.func_177230_c() != this) {
            return;
        }
        if ((Boolean)adjacent_state.func_177229_b((Property)field_176519_b) == open) {
            return;
        }
        world.func_180501_a(adjecent_pos, (BlockState)adjacent_state.func_206870_a((Property)field_176519_b, (Comparable)Boolean.valueOf(open)), 10);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    public boolean func_181623_g() {
        return false;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.shapes_[((Direction)state.func_177229_b((Property)field_176520_a)).ordinal()][(Boolean)state.func_177229_b((Property)field_176519_b) != false ? 1 : 0][state.func_177229_b((Property)field_176521_M) == DoorHingeSide.RIGHT ? 1 : 0][state.func_177229_b((Property)field_176523_O) == DoubleBlockHalf.UPPER ? 0 : 1];
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        this.func_242663_a(world, state, pos, (Boolean)state.func_177229_b((Property)field_176519_b) == false);
        return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        boolean bl = world.func_175640_z(pos) || world.func_175640_z(pos.func_177972_a(state.func_177229_b((Property)field_176523_O) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (powered = false);
        if (block == this || powered == (Boolean)state.func_177229_b((Property)field_176522_N)) {
            return;
        }
        world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)field_176522_N, (Comparable)Boolean.valueOf(powered))).func_206870_a((Property)field_176519_b, (Comparable)Boolean.valueOf(powered)), 2);
        this.actuate_adjacent_wing(state, (IBlockReader)world, pos, powered);
        if (powered != (Boolean)state.func_177229_b((Property)field_176519_b)) {
            this.sound((IBlockReader)world, pos, powered);
        }
    }

    public void func_242663_a(World world, BlockState state, BlockPos pos, boolean open) {
        if (!state.func_203425_a((Block)this) || (Boolean)state.func_177229_b((Property)field_176519_b) == open) {
            return;
        }
        state = (BlockState)state.func_206870_a((Property)field_176519_b, (Comparable)Boolean.valueOf(open));
        world.func_180501_a(pos, state, 10);
        this.sound((IBlockReader)world, pos, open);
        this.actuate_adjacent_wing(state, (IBlockReader)world, pos, open);
    }
}

