/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.detail.Inventories;

public class EdStraightPoleBlock
extends DecorBlock.DirectedWaterLoggable
implements IDecorBlock {
    private final EdStraightPoleBlock default_pole;

    public EdStraightPoleBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB unrotatedAABB, @Nullable EdStraightPoleBlock defaultPole) {
        super(config, builder, unrotatedAABB);
        this.default_pole = defaultPole == null ? this : defaultPole;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        World world;
        Direction facing = context.func_196000_l();
        BlockState state = (BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)facing);
        if ((this.config & 0x100L) != 0L && (world = context.func_195991_k()).func_180495_p((pos = context.func_195995_a()).func_177972_a(facing.func_176734_d())).func_177230_c() instanceof EdStraightPoleBlock) {
            state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)((Direction)state.func_177229_b((Property)FACING)).func_176734_d());
        }
        return state;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        DirectionalPlaceContext ctx;
        if (hit.func_216354_b().func_176740_k() == ((Direction)state.func_177229_b((Property)FACING)).func_176740_k()) {
            return ActionResultType.PASS;
        }
        ItemStack held_stack = player.func_184586_b(hand);
        if (held_stack.func_190926_b() || !(held_stack.func_77973_b() instanceof BlockItem)) {
            return ActionResultType.PASS;
        }
        if (!(((BlockItem)held_stack.func_77973_b()).func_179223_d() instanceof EdStraightPoleBlock)) {
            return ActionResultType.PASS;
        }
        if (held_stack.func_77973_b() != this.default_pole.func_199767_j()) {
            return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
        }
        Block held_block = ((BlockItem)held_stack.func_77973_b()).func_179223_d();
        Direction block_direction = (Direction)state.func_177229_b((Property)FACING);
        Vector3d block_vec = Vector3d.func_237491_b_((Vector3i)((Direction)state.func_177229_b((Property)FACING)).func_176730_m());
        double colinearity = 1.0 - block_vec.func_72431_c(player.func_70040_Z()).func_72433_c();
        Direction placement_direction = Arrays.stream(Direction.func_196054_a((Entity)player)).filter(d -> d.func_176740_k() == block_direction.func_176740_k()).findFirst().orElse(Direction.NORTH);
        BlockPos adjacent_pos = pos.func_177972_a(placement_direction);
        BlockState adjacent = world.func_180495_p(adjacent_pos);
        if (!adjacent.func_196953_a((BlockItemUseContext)(ctx = new DirectionalPlaceContext(world, adjacent_pos, placement_direction, player.func_184586_b(hand), placement_direction.func_176734_d())))) {
            return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
        }
        BlockState new_state = held_block.func_196258_a((BlockItemUseContext)ctx);
        if (new_state == null) {
            return ActionResultType.FAIL;
        }
        if (!world.func_180501_a(adjacent_pos, new_state, 3)) {
            return ActionResultType.FAIL;
        }
        world.func_184133_a(player, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!player.func_184812_l_()) {
            held_stack.func_190918_g(1);
            Inventories.setItemInPlayerHand(player, hand, held_stack);
        }
        return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
    }
}

