/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.util;

import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public final class GuiUtils {
    private GuiUtils() {
    }

    public static void renderText(MatrixStack matrix, int x, int y, float scale, String text, int color) {
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)x, (double)y, 0.0);
        matrix.func_227862_a_(scale, scale, 1.0f);
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrix, text, 0.0f, 0.0f, color);
        matrix.func_227865_b_();
    }

    public static final class Tooltip {
        private final List<ITextComponent> value = new ArrayList<ITextComponent>();

        private Tooltip() {
        }

        public static Tooltip builder() {
            return new Tooltip();
        }

        public List<ITextComponent> resolve() {
            return this.value;
        }

        public Tooltip addBlankLine() {
            return this.addComponent((ITextComponent)new StringTextComponent(" "));
        }

        public Tooltip addComponent(ITextComponent component) {
            this.value.add(component);
            return this;
        }

        public Tooltip addHeader(String key) {
            return this.addComponent((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, TextFormatting.GOLD));
        }

        public Tooltip addDescription(String key) {
            return this.addComponent((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, TextFormatting.WHITE));
        }

        public Tooltip addCustomAction(String input, String key) {
            return this.addComponent((ITextComponent)TextUtils.colorize("> ", TextFormatting.GRAY).func_230529_a_((ITextComponent)TextUtils.colorize(InputMappings.func_197955_a((String)input).func_237520_d_().getString(), TextFormatting.AQUA)).func_240702_b_(" ").func_230529_a_((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, TextFormatting.GRAY)));
        }

        public Tooltip addClickAction(String key) {
            return this.addComponent((ITextComponent)TextUtils.colorize("> ", TextFormatting.GRAY).func_230529_a_((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "action_click", TextFormatting.AQUA)).func_240702_b_(" ").func_230529_a_((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, TextFormatting.GRAY)));
        }

        public Tooltip addHoldAction(String input, String key) {
            return this.addComponent((ITextComponent)TextUtils.colorize("> ", TextFormatting.GRAY).func_230529_a_((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "action_hold", TextFormatting.GRAY)).func_240702_b_(" ").func_230529_a_((ITextComponent)TextUtils.colorize(InputMappings.func_197955_a((String)input).func_237520_d_().getString(), TextFormatting.AQUA)).func_240702_b_(" ").func_230529_a_((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, TextFormatting.GRAY)));
        }

        public Tooltip addShiftClickAction(String key) {
            return this.addComponent((ITextComponent)TextUtils.colorize("> ", TextFormatting.GRAY).func_230529_a_((ITextComponent)TextUtils.colorize(String.format("%s + %s", InputMappings.func_197955_a((String)"key.keyboard.left.shift").func_237520_d_().getString(), TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "action_click")), TextFormatting.AQUA)).func_240702_b_(" ").func_230529_a_((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, TextFormatting.GRAY)));
        }
    }
}

