/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.network;

import com.github.almostreliable.energymeter.component.SideConfiguration;
import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.meter.MeterTile;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class IOUpdatePacket {
    private TypeEnums.BLOCK_SIDE side;
    private TypeEnums.IO_SETTING setting;

    public IOUpdatePacket(TypeEnums.BLOCK_SIDE side, TypeEnums.IO_SETTING setting) {
        this.side = side;
        this.setting = setting;
    }

    private IOUpdatePacket() {
    }

    static IOUpdatePacket decode(PacketBuffer buffer) {
        IOUpdatePacket packet = new IOUpdatePacket();
        packet.side = TypeEnums.BLOCK_SIDE.values()[buffer.readInt()];
        packet.setting = TypeEnums.IO_SETTING.values()[buffer.readInt()];
        return packet;
    }

    static void handle(IOUpdatePacket packet, Supplier<? extends NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        context.get().enqueueWork(() -> IOUpdatePacket.handlePacket(packet, player));
        context.get().setPacketHandled(true);
    }

    private static void handlePacket(IOUpdatePacket packet, @Nullable ServerPlayerEntity player) {
        if (player != null && player.field_71070_bA instanceof MeterContainer) {
            MeterTile tile = ((MeterContainer)player.field_71070_bA).getTile();
            World level = tile.func_145831_w();
            if (level == null || !level.func_195588_v(tile.func_174877_v())) {
                return;
            }
            tile.getSideConfig().set(tile.func_195044_w(), packet.side, packet.setting);
            tile.updateNeighbors();
            tile.updateCache(SideConfiguration.getDirectionFromSide(tile.func_195044_w(), packet.side));
            tile.syncData(1);
            tile.func_70296_d();
        }
    }

    void encode(PacketBuffer buffer) {
        buffer.writeInt(this.side.ordinal());
        buffer.writeInt(this.setting.ordinal());
    }
}

