/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.compat.cct;

import com.github.almostreliable.energymeter.compat.IMeterTileObserver;
import com.github.almostreliable.energymeter.meter.MeterTile;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;

public class MeterPeripheral
implements IPeripheral,
IMeterTileObserver {
    private final MeterTile tile;
    private IComputerAccess computer;

    MeterPeripheral(MeterTile tile) {
        this.tile = tile;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getSideConfig(Direction direction) {
        return MethodResult.of((Object)this.tile.getSideConfig().get(direction).name());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult hasInput() {
        return MethodResult.of((Object)this.tile.getSideConfig().hasInput());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult hasOutput() {
        return MethodResult.of((Object)this.tile.getSideConfig().hasOutput());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult hasMaxOutputs() {
        return MethodResult.of((Object)this.tile.getSideConfig().hasMaxOutputs());
    }

    @Override
    public void onMeterTileChanged(MeterTile tile, int flags) {
        if (!((Object)((Object)this.tile)).equals((Object)tile)) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        if ((flags & 1) != 0) {
            data.put("side_config", tile.getSideConfig().asStringMap());
        }
        if ((flags & 2) != 0) {
            data.put("transfer_rate", tile.getTransferRate());
        }
        if ((flags & 4) != 0) {
            data.put("number_mode", tile.getNumberMode().name());
        }
        if ((flags & 8) != 0) {
            data.put("status", tile.getStatus().name());
        }
        if ((flags & 0x10) != 0) {
            data.put("mode", tile.getMode().name());
        }
        if ((flags & 0x20) != 0) {
            data.put("accuracy", tile.getAccuracy().name());
        }
        if ((flags & 0x40) != 0) {
            data.put("interval", tile.getInterval());
        }
        if ((flags & 0x80) != 0) {
            data.put("threshold", tile.getThreshold());
        }
        this.computer.queueEvent("em_data_changed", new Object[]{data});
    }

    @Override
    public void onMeterTileRemoved(MeterTile tile) {
        this.computer.queueEvent("em_removed", new Object[0]);
    }

    @Nonnull
    public String getType() {
        return "energymeter";
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.computer = computer;
        this.tile.subscribe(this);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.tile.unsubscribe(this);
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof MeterPeripheral && ((Object)((Object)this.tile)).equals((Object)((MeterPeripheral)other).tile);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getInterval() {
        return MethodResult.of((Object)this.tile.getInterval());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getTransferRate() {
        return MethodResult.of((Object)this.tile.getTransferRate());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getThreshold() {
        return MethodResult.of((Object)this.tile.getThreshold());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getNumberMode() {
        return MethodResult.of((Object)this.tile.getNumberMode().name());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getMode() {
        return MethodResult.of((Object)this.tile.getMode().name());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getAccuracy() {
        return MethodResult.of((Object)this.tile.getAccuracy().name());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getStatus() {
        return MethodResult.of((Object)this.tile.getStatus().name());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getFullSideConfig() {
        return MethodResult.of(this.tile.getSideConfig().asStringMap());
    }
}

