/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.client.gui;

import com.github.almostreliable.energymeter.client.gui.GenericButton;
import com.github.almostreliable.energymeter.client.gui.MeterScreen;
import com.github.almostreliable.energymeter.network.PacketHandler;
import com.github.almostreliable.energymeter.network.SettingUpdatePacket;
import com.github.almostreliable.energymeter.util.GuiUtils;
import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

class SettingButton
extends GenericButton {
    private static final String TEXTURE = "setting";
    private static final int TEXTURE_WIDTH = 63;
    private static final int TEXTURE_HEIGHT = 21;
    private final String label;
    private final FontRenderer font;
    private final TypeEnums.SETTING setting;
    private GuiUtils.Tooltip tooltip;
    private GuiUtils.Tooltip tooltipLong;

    SettingButton(MeterScreen screen, int pX, int pY, TypeEnums.SETTING setting) {
        super(screen, pX, pY, 63, 21);
        this.setting = setting;
        this.label = TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, setting.toString().toLowerCase()).toUpperCase();
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.tooltip = this.setupTooltip(false);
        this.tooltipLong = this.setupTooltip(true);
    }

    @Override
    public void func_230431_b_(MatrixStack matrix, int mX, int mY, float partial) {
        super.func_230431_b_(matrix, mX, mY, partial);
        int pX = (this.field_230688_j_ - this.font.func_78256_a(this.label)) / 2 + this.field_230690_l_ + 1;
        this.font.getClass();
        int pY = (this.field_230689_k_ - 9) / 2 + this.field_230691_m_ + 1;
        GuiUtils.renderText(matrix, pX, pY, 1.0f, this.label, 0xF0F0F0);
    }

    @Override
    protected void clickHandler() {
        PacketHandler.CHANNEL.sendToServer((Object)new SettingUpdatePacket(this.setting));
        this.container.getTile().updateSetting(this.setting);
        if (this.setting == TypeEnums.SETTING.ACCURACY) {
            this.screen.getIntervalBox().reset();
            this.screen.getThresholdBox().reset();
        }
        this.tooltip = this.setupTooltip(false);
        this.tooltipLong = this.setupTooltip(true);
    }

    @Override
    protected String getTexture() {
        return TEXTURE;
    }

    @Override
    protected int getTextureWidth() {
        return 63;
    }

    @Override
    protected int getTextureHeight() {
        return 21;
    }

    public void func_230443_a_(MatrixStack matrix, int mX, int mY) {
        this.screen.func_243308_b(matrix, (Screen.func_231173_s_() ? this.tooltipLong : this.tooltip).resolve(), mX, mY);
    }

    private GuiUtils.Tooltip setupTooltip(boolean longTooltip) {
        String settingKey = this.setting.toString().toLowerCase();
        GuiUtils.Tooltip t = GuiUtils.Tooltip.builder().addHeader(settingKey).addBlankLine();
        if (longTooltip) {
            t.addDescription(settingKey + "_desc_1");
            String description2 = "_desc_2";
            if (this.setting == TypeEnums.SETTING.NUMBER) {
                t.addDescription(settingKey + description2);
            }
            if (this.setting == TypeEnums.SETTING.MODE) {
                IFormattableTextComponent transfer = TextUtils.translate(TypeEnums.TRANSLATE_TYPE.MODE, TypeEnums.MODE.TRANSFER.toString().toLowerCase(), new TextFormatting[0]).func_240702_b_(":");
                Style style1 = transfer.func_150256_b().func_240718_a_(Color.func_240743_a_((int)40929));
                IFormattableTextComponent consumer = TextUtils.translate(TypeEnums.TRANSLATE_TYPE.MODE, TypeEnums.MODE.CONSUMER.toString().toLowerCase(), new TextFormatting[0]).func_240702_b_(":");
                Style style2 = consumer.func_150256_b().func_240718_a_(Color.func_240743_a_((int)12976383));
                t.addBlankLine().addComponent((ITextComponent)transfer.func_240703_c_(style1)).addDescription(settingKey + description2).addBlankLine().addComponent((ITextComponent)consumer.func_240703_c_(style2)).addDescription(settingKey + "_desc_3");
            }
            if (this.setting == TypeEnums.SETTING.ACCURACY) {
                IFormattableTextComponent exact = TextUtils.translate(TypeEnums.TRANSLATE_TYPE.ACCURACY, TypeEnums.ACCURACY.EXACT.toString().toLowerCase(), new TextFormatting[0]).func_240702_b_(":");
                Style style3 = exact.func_150256_b().func_240718_a_(Color.func_240743_a_((int)0xFF6600));
                IFormattableTextComponent interval = TextUtils.translate(TypeEnums.TRANSLATE_TYPE.ACCURACY, TypeEnums.ACCURACY.INTERVAL.toString().toLowerCase(), new TextFormatting[0]).func_240702_b_(":");
                Style style4 = interval.func_150256_b().func_240718_a_(Color.func_240743_a_((int)0xFF0066));
                t.addBlankLine().addComponent((ITextComponent)exact.func_240703_c_(style3)).addDescription(settingKey + description2).addBlankLine().addComponent((ITextComponent)interval.func_240703_c_(style4)).addDescription(settingKey + "_desc_3");
            }
            t.addBlankLine();
        }
        IFormattableTextComponent currentSetting = TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "current", TextFormatting.GREEN).func_230529_a_((ITextComponent)TextUtils.colorize(": ", TextFormatting.GREEN));
        switch (this.setting) {
            case NUMBER: {
                currentSetting.func_230529_a_((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.NUMBER, this.container.getTile().getNumberMode().toString().toLowerCase(), TextFormatting.WHITE));
                break;
            }
            case MODE: {
                currentSetting.func_230529_a_((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.MODE, this.container.getTile().getMode().toString().toLowerCase(), TextFormatting.WHITE));
                break;
            }
            case ACCURACY: {
                currentSetting.func_230529_a_((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.ACCURACY, this.container.getTile().getAccuracy().toString().toLowerCase(), TextFormatting.WHITE));
            }
        }
        t.addComponent((ITextComponent)currentSetting).addBlankLine();
        if (!longTooltip) {
            t.addHoldAction("key.keyboard.left.shift", "action_4");
        }
        return t.addClickAction("action_3");
    }
}

