/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.client.gui;

import com.github.almostreliable.energymeter.client.gui.MeterScreen;
import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.network.AccuracyUpdatePacket;
import com.github.almostreliable.energymeter.network.PacketHandler;
import com.github.almostreliable.energymeter.util.GuiUtils;
import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.StringUtils;

abstract class GenericTextBox
extends TextFieldWidget {
    protected final MeterScreen screen;
    private final FontRenderer font;
    private final TypeEnums.TEXT_BOX identifier;

    GenericTextBox(MeterScreen screen, FontRenderer font, int pX, int pY, int width, int height, TypeEnums.TEXT_BOX identifier) {
        super(font, pX, pY, width, height, StringTextComponent.field_240750_d_);
        this.screen = screen;
        this.font = font;
        this.identifier = identifier;
        this.func_146185_a(false);
        this.func_146193_g(0xF0F0F0);
        this.func_200675_a(text -> StringUtils.isNumeric((CharSequence)text) || text.isEmpty());
        this.func_146203_f(7);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == InputMappings.func_197955_a((String)"key.keyboard.enter").func_197937_c()) {
            this.func_146195_b(false);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231044_a_(double pMouseX, double pMouseY, int pButton) {
        boolean clicked = super.func_231044_a_(pMouseX, pMouseY, pButton);
        if (clicked && Screen.func_231173_s_()) {
            this.reset();
            if (this.identifier == TypeEnums.TEXT_BOX.INTERVAL) {
                this.screen.getThresholdBox().reset();
            }
        }
        return clicked;
    }

    public void func_146195_b(boolean focused) {
        if (this.func_230999_j_() && !focused) {
            this.screen.getIntervalBox().validateTextBox();
            this.screen.getThresholdBox().validateTextBox();
        }
        super.func_146195_b(focused);
    }

    public void func_230431_b_(MatrixStack matrix, int mX, int mY, float partial) {
        if (((MeterContainer)this.screen.func_212873_a_()).getTile().getAccuracy() == TypeEnums.ACCURACY.EXACT) {
            return;
        }
        String label = TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, this.identifier.toString().toLowerCase()) + ":";
        int labelWidth = this.font.func_78256_a(label);
        this.field_230692_n_ = mX >= this.field_230690_l_ - 4 - labelWidth && mY >= this.field_230691_m_ - 3 && mX < this.field_230690_l_ + this.field_230688_j_ + 3 && mY < this.field_230691_m_ + this.field_230689_k_ + 3;
        GuiUtils.renderText(matrix, this.field_230690_l_ - 4 - labelWidth, this.field_230691_m_, 1.0f, label, 0xF0F0F0);
        GenericTextBox.func_238467_a_((MatrixStack)matrix, (int)(this.field_230690_l_ - 3), (int)(this.field_230691_m_ - 3), (int)(this.field_230690_l_ + this.field_230688_j_ + 3), (int)(this.field_230691_m_ + this.field_230689_k_ + 3), (int)-65434);
        GenericTextBox.func_238467_a_((MatrixStack)matrix, (int)(this.field_230690_l_ - 2), (int)(this.field_230691_m_ - 2), (int)(this.field_230690_l_ + this.field_230688_j_ + 2), (int)(this.field_230691_m_ + this.field_230689_k_ + 2), (int)-15263977);
        super.func_230431_b_(matrix, mX, mY, partial);
    }

    protected void changeTextBoxValue(int value, boolean sync) {
        this.func_146180_a(String.valueOf(Math.max(value, 5)));
        if (sync) {
            PacketHandler.CHANNEL.sendToServer((Object)new AccuracyUpdatePacket(this.identifier, Math.max(value, 5)));
        }
    }

    void reset() {
        this.changeTextBoxValue(5, true);
    }

    void validateTextBox() {
        int value;
        int oldValue = this.getOldValue();
        try {
            value = Integer.parseInt(this.func_146179_b());
        }
        catch (NumberFormatException e) {
            this.changeTextBoxValue(oldValue, false);
            return;
        }
        if (value != oldValue) {
            this.changeTextBoxValue(value, true);
        }
    }

    public boolean func_230449_g_() {
        return this.field_230692_n_;
    }

    public void func_230443_a_(MatrixStack matrix, int mX, int mY) {
        if (((MeterContainer)this.screen.func_212873_a_()).getTile().getAccuracy() == TypeEnums.ACCURACY.EXACT) {
            return;
        }
        this.screen.func_243308_b(matrix, this.getTooltip().resolve(), mX, mY);
    }

    public void func_230996_d_(boolean focused) {
        super.func_230996_d_(focused);
    }

    protected abstract GuiUtils.Tooltip getTooltip();

    protected abstract int getOldValue();
}

