/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.handlers.mekanism;

import java.util.Random;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import shetiphian.core.client.Localization;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.modintegration.handlers.mekanism.WrapperInfusionHandler;

public class TypeInfusion {
    public static void init() {
        if (((Boolean)Configuration.INTEGRATION.storeMekanismInfusion.get()).booleanValue() && IInfusionHandler.class != null) {
            HandlerRegistry.register(Capabilities.INFUSION_HANDLER_CAPABILITY, InfusionTankHandler.Provider.INSTANCE);
        }
    }

    public static class InfusionTankHandler
    implements ITankHandler<IInfusionHandler> {
        private final ChemicalTankBuilder.BasicInfusionTank infusionTank;
        private final IInfusionHandler infusionTankInsertOnly;
        private final IInfusionHandler infusionTankExtractOnly;
        private long tankCapacity;

        public InfusionTankHandler(final IEnderTankInfo tank) {
            this.tankCapacity = tank.getCapacity() * 1000;
            this.infusionTank = new ChemicalTankBuilder.BasicInfusionTank(this.tankCapacity, (stack, type) -> true, (stack, type) -> true, stack -> true, ChemicalAttributeValidator.ALWAYS_ALLOW, null){

                public long getCapacity() {
                    return tankCapacity;
                }

                public void onContentsChanged() {
                    tank.notifyContentsChange();
                }
            };
            this.infusionTankInsertOnly = new WrapperInfusionHandler((IInfusionHandler)this.infusionTank, true, false);
            this.infusionTankExtractOnly = new WrapperInfusionHandler((IInfusionHandler)this.infusionTank, false, true);
        }

        @Override
        public IInfusionHandler getTank(StorageAccessMode access) {
            switch (access) {
                case INSERT_ONLY: {
                    return this.infusionTankInsertOnly;
                }
                case EXTRACT_ONLY: {
                    return this.infusionTankExtractOnly;
                }
            }
            return this.infusionTank;
        }

        @Override
        public void setCapacity(int capacity) {
            int newCapacity = capacity * 1000;
            if (this.tankCapacity != (long)newCapacity) {
                this.tankCapacity = newCapacity;
                this.infusionTank.onContentsChanged();
            }
        }

        @Override
        public void load(CompoundNBT nbt) {
            this.infusionTank.deserializeNBT(nbt);
        }

        @Override
        public CompoundNBT save() {
            return !this.infusionTank.isEmpty() ? this.infusionTank.serializeNBT() : null;
        }

        @Override
        public String getContentsInfo() {
            InfusionStack stack = (InfusionStack)this.infusionTank.getStack();
            if (!stack.isEmpty()) {
                return String.format(" %s %s [%sK/%sK mB]", Localization.get((String)"info.endertanks.tank.type.mekanism.infusion.txt"), Localization.get((String)((InfuseType)stack.getType()).getTranslationKey()), Float.valueOf((float)stack.getAmount() / 1000.0f), this.infusionTank.getCapacity() / 1000L);
            }
            return "";
        }

        @Override
        public void preformPumpAction(World world, BlockPos pos, Direction facing, BlockPos pullFromPos, BlockPos pushToPos, int pumpCapacity, Random random) {
            InfusionStack infusionStack;
            long used;
            IInfusionHandler fromHandler = this.getHandler(world.func_175625_s(pullFromPos), facing);
            IInfusionHandler toHandler = this.getHandler(world.func_175625_s(pushToPos), facing.func_176734_d());
            if (fromHandler != null && (used = (infusionStack = (InfusionStack)fromHandler.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((InfusionStack)this.infusionTank.insertChemical((ChemicalStack)infusionStack, Action.SIMULATE)).getAmount()) > 0L) {
                this.infusionTank.insertChemical(fromHandler.extractChemical(used, Action.EXECUTE), Action.EXECUTE);
            }
            if (toHandler != null && (used = (infusionStack = (InfusionStack)this.infusionTank.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((InfusionStack)toHandler.insertChemical((ChemicalStack)infusionStack, Action.SIMULATE)).getAmount()) > 0L) {
                toHandler.insertChemical(this.infusionTank.extractChemical(used, Action.EXECUTE), Action.EXECUTE);
            }
        }

        public IInfusionHandler getHandler(TileEntity tile, Direction facing) {
            return tile == null ? null : (IInfusionHandler)tile.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY, facing).orElse(null);
        }

        public static class Provider
        implements HandlerRegistry.ITankHandlerProvider<IInfusionHandler> {
            public static Provider INSTANCE = new Provider();

            @Override
            public ITankHandler<IInfusionHandler> create(IEnderTankInfo tank) {
                return new InfusionTankHandler(tank);
            }
        }
    }
}

