/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client.render;

import codechicken.lib.vec.Matrix4;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.EndPortalTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Vector3d;

public class RenderCustomEndPortal {
    private static final FloatBuffer texBuffer = GLAllocation.func_74529_h((int)16);
    private static final List<RenderType.State> RENDER_STATES = (List)IntStream.range(0, 16).mapToObj(i -> RenderType.State.func_228694_a_().func_228726_a_(i == 0 ? RenderType.field_228515_g_ : RenderType.field_228511_c_).func_228724_a_(new RenderState.TextureState(i == 0 ? EndPortalTileEntityRenderer.field_147529_c : EndPortalTileEntityRenderer.field_147526_d, false, false)).func_228728_a_(false)).collect(ImmutableList.toImmutableList());
    private final Random randy = new Random();
    private final double surfaceY;
    private final double surfaceX1;
    private final double surfaceX2;
    private final double surfaceZ1;
    private final double surfaceZ2;

    public RenderCustomEndPortal(double y, double x1, double x2, double z1, double z2) {
        this.surfaceY = y;
        this.surfaceX1 = x1;
        this.surfaceX2 = x2;
        this.surfaceZ1 = z1;
        this.surfaceZ2 = z2;
    }

    public void render(Matrix4 mat, IRenderTypeBuffer getter, double yToCamera) {
        Vector3d projectedView = TileEntityRendererDispatcher.field_147556_a.field_217666_g.func_216785_c();
        mat = mat.copy();
        this.randy.setSeed(31100L);
        for (int i = 0; i < 16; ++i) {
            RenderType.State state = RENDER_STATES.get(i);
            EndPortalRenderType renderType = new EndPortalRenderType(i, yToCamera, projectedView, mat, state);
            IVertexBuilder builder = getter.getBuffer((RenderType)renderType);
            float r = (this.randy.nextFloat() * 0.5f + 0.1f) * renderType.f7;
            float g = (this.randy.nextFloat() * 0.5f + 0.4f) * renderType.f7;
            float b = (this.randy.nextFloat() * 0.5f + 0.5f) * renderType.f7;
            if (i == 0) {
                g = b = 1.0f * renderType.f7;
                r = b;
            }
            builder.func_225582_a_(this.surfaceX1, this.surfaceY, this.surfaceZ1).func_227885_a_(r, g, b, 1.0f).func_181675_d();
            builder.func_225582_a_(this.surfaceX1, this.surfaceY, this.surfaceZ2).func_227885_a_(r, g, b, 1.0f).func_181675_d();
            builder.func_225582_a_(this.surfaceX2, this.surfaceY, this.surfaceZ2).func_227885_a_(r, g, b, 1.0f).func_181675_d();
            builder.func_225582_a_(this.surfaceX2, this.surfaceY, this.surfaceZ1).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        }
    }

    private static FloatBuffer bufferTexData(float f, float f1, float f2, float f3) {
        texBuffer.clear();
        texBuffer.put(f).put(f1).put(f2).put(f3);
        texBuffer.flip();
        return texBuffer;
    }

    public class EndPortalRenderType
    extends RenderType {
        private final int idx;
        private final Vector3d projectedView;
        private final Matrix4 mat;
        private final RenderType.State state;
        public final float f5;
        public final float f6;
        public final float f7;
        public final float f8;
        public final float f9;
        public final float f10;
        public final float f11;

        public EndPortalRenderType(int idx, double posY, Vector3d projectedView, Matrix4 mat, RenderType.State state) {
            super("enderstorage:end_portal", DefaultVertexFormats.field_181706_f, 7, 256, false, true, null, null);
            this.idx = idx;
            this.projectedView = projectedView;
            this.mat = mat;
            this.state = state;
            float f = this.f5 = idx == 0 ? 65.0f : (float)(16 - idx);
            this.f6 = idx == 0 ? 0.125f : (idx == 1 ? 0.5f : 0.0625f);
            this.f7 = idx == 0 ? 0.1f : 1.0f / ((float)(16 - idx) + 1.0f);
            this.f8 = (float)(-(posY + RenderCustomEndPortal.this.surfaceY));
            this.f9 = (float)((double)this.f8 + projectedView.field_72448_b);
            this.f10 = (float)((double)(this.f8 + this.f5) + projectedView.field_72448_b);
            this.f11 = (float)(posY + RenderCustomEndPortal.this.surfaceY) + this.f9 / this.f10;
        }

        public void func_228547_a_() {
            this.state.field_228693_q_.forEach(RenderState::func_228547_a_);
            RenderSystem.disableLighting();
            RenderSystem.pushMatrix();
            this.mat.glApply();
            RenderSystem.pushMatrix();
            GlStateManager.func_227670_b_((double)this.projectedView.field_72450_a, (double)this.f11, (double)this.projectedView.field_72449_c);
            GlStateManager.func_227663_a_((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9217);
            GlStateManager.func_227663_a_((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9217);
            GlStateManager.func_227663_a_((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9217);
            GlStateManager.func_227663_a_((GlStateManager.TexGen)GlStateManager.TexGen.Q, (int)9216);
            GlStateManager.func_227664_a_((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9473, (FloatBuffer)RenderCustomEndPortal.bufferTexData(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.func_227664_a_((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9473, (FloatBuffer)RenderCustomEndPortal.bufferTexData(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.func_227664_a_((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9473, (FloatBuffer)RenderCustomEndPortal.bufferTexData(0.0f, 0.0f, 0.0f, 1.0f));
            GlStateManager.func_227664_a_((GlStateManager.TexGen)GlStateManager.TexGen.Q, (int)9474, (FloatBuffer)RenderCustomEndPortal.bufferTexData(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.func_227662_a_((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.func_227662_a_((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.func_227662_a_((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.func_227662_a_((GlStateManager.TexGen)GlStateManager.TexGen.Q);
            RenderSystem.popMatrix();
            RenderSystem.matrixMode((int)5890);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            RenderSystem.translatef((float)0.0f, (float)((float)(System.currentTimeMillis() % 700000L) / 700000.0f), (float)0.0f);
            RenderSystem.scalef((float)this.f6, (float)this.f6, (float)this.f6);
            RenderSystem.translatef((float)0.5f, (float)0.5f, (float)0.0f);
            RenderSystem.rotatef((float)((float)(this.idx * this.idx * 4321 + this.idx * 9) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.translatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            RenderSystem.translated((double)(-this.projectedView.field_72450_a), (double)(-this.projectedView.field_72449_c), (double)(-this.projectedView.field_72448_b));
            float f92 = this.f8 + (float)this.projectedView.field_72448_b;
            RenderSystem.translated((double)(this.projectedView.field_72450_a * (double)this.f5 / (double)f92), (double)(this.projectedView.field_72449_c * (double)this.f5 / (double)f92), (double)(-this.projectedView.field_72448_b + 20.0));
        }

        public void func_228549_b_() {
            RenderSystem.popMatrix();
            RenderSystem.matrixMode((int)5888);
            RenderSystem.popMatrix();
            GlStateManager.func_227685_b_((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.func_227685_b_((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.func_227685_b_((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.func_227685_b_((GlStateManager.TexGen)GlStateManager.TexGen.Q);
            this.state.field_228693_q_.forEach(RenderState::func_228549_b_);
        }

        public boolean equals(Object other) {
            return other == this;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    }
}

