/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.tileentity;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.NameHelper;
import shetiphian.core.common.inventory.IContainerCallback;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.misc.LocationManager;

public class TileEntityEnderChest
extends TileEntityBase
implements ITickableTileEntity,
IRGB16_Tile,
IContainerCallback {
    private String code = "000";
    private String ownerID = null;
    private String owner = "all";
    private ItemStack personalItem;
    private float lidAngle;
    private float prevLidAngle;
    private int numPlayersUsing;
    private int ticksSinceSync;
    private final List<String> usedUpgrades = new ArrayList<String>();

    public TileEntityEnderChest() {
        super(Values.tileEnderChest);
    }

    public void buildNBT(CompoundNBT nbtTag) {
        nbtTag.func_74778_a("code", this.getCode());
        nbtTag.func_74778_a("owner", this.owner);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            nbtTag.func_74778_a("owner.id", this.ownerID);
        }
        nbtTag.func_74778_a("owner_id", this.getOwnerID());
        if (this.personalItem != null) {
            CompoundNBT compound = new CompoundNBT();
            this.personalItem.func_77955_b(compound);
            nbtTag.func_218657_a("upgrade.access", (INBT)compound);
            nbtTag.func_74778_a("personal", this.personalItem.func_77973_b().getRegistryName().toString());
        }
        if (!this.usedUpgrades.isEmpty()) {
            ListNBT listNBT = new ListNBT();
            for (String upgrade : this.usedUpgrades) {
                listNBT.add((Object)StringNBT.func_229705_a_((String)upgrade));
            }
            nbtTag.func_218657_a("used_upgrades", (INBT)listNBT);
        }
    }

    public void processNBT(CompoundNBT nbtTag) {
        this.setCode(nbtTag.func_74779_i("code"));
        this.owner = nbtTag.func_74779_i("owner");
        if (nbtTag.func_74764_b("owner.id")) {
            this.ownerID = nbtTag.func_74779_i("owner.id");
        }
        if (nbtTag.func_74764_b("upgrade.access")) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("upgrade.access"));
            if (!stack.func_190926_b() && stack.func_190916_E() != 1) {
                stack.func_190920_e(1);
            }
            this.personalItem = stack;
        }
        if (nbtTag.func_74764_b("used_upgrades")) {
            this.usedUpgrades.clear();
            ListNBT listNBT = nbtTag.func_150295_c("used_upgrades", 8);
            listNBT.listIterator().forEachRemaining(entry -> this.usedUpgrades.add(entry.func_150285_a_()));
        }
    }

    public void processNBT_SaveOnly(CompoundNBT nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            this.owner = NameHelper.getDisplayNameFor((String)this.ownerID);
        }
    }

    public boolean applyItem(ItemStack stack) {
        String key = stack.func_77973_b().getRegistryName().toString();
        if (this.usedUpgrades.contains(key)) {
            return false;
        }
        this.usedUpgrades.add(key);
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1));
    }

    public void func_73660_a() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.func_145831_w().field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + x + y + z) % 200 == 0) {
            this.numPlayersUsing = 0;
            for (PlayerEntity player : this.func_145831_w().func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
                if (!(player.field_71070_bA instanceof ContainerEnderChest) || !((ContainerEnderChest)player.field_71070_bA).isParentTile(this)) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.func_145831_w().func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float oldAngle = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.075f) : (this.lidAngle -= 0.075f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && oldAngle >= 0.5f) {
                this.func_145831_w().func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getLidAngle(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    public int getLidOffsetIndex() {
        return Math.round(this.lidAngle * 100.0f) / 10;
    }

    public boolean func_145842_c(int id, int value) {
        if (id == 1) {
            this.numPlayersUsing = value;
            return true;
        }
        return super.func_145842_c(id, value);
    }

    public boolean isOpen() {
        return this.numPlayersUsing > 0;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.canBeAutomated()) {
            return LazyOptional.of(() -> new InvWrapper((IInventory)this.getChest())).cast();
        }
        return super.getCapability(capability, side);
    }

    private boolean canBeAutomated() {
        return this.isPublic() ? (Boolean)Configuration.ACCESS_SETTINGS.enableAutomationPublic.get() : (this.isTeam() ? ((Boolean)Configuration.ACCESS_SETTINGS.enableAutomationTeam.get()).booleanValue() : ((Boolean)Configuration.ACCESS_SETTINGS.enableAutomationPersonal.get()).booleanValue());
    }

    public InventoryInternal getChest() {
        return ChestHelper.getChest(this.func_145831_w(), this.getOwnerID(), this.getCode());
    }

    public boolean canInteractWith(TileEntity owner, IInventory inventory, PlayerEntity player, boolean original) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void onContainerOpen(TileEntity owner, IInventory inventory, PlayerEntity player) {
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        if (!player.func_175149_v()) {
            ++this.numPlayersUsing;
            this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, this.numPlayersUsing);
            this.func_145831_w().func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
        }
    }

    public void onContainerClosed(TileEntity owner, IInventory inventory, PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, this.numPlayersUsing);
            this.func_145831_w().func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
        }
    }

    public boolean canEdit(PlayerEntity player) {
        boolean canEdit = true;
        String msg = "";
        if (!player.field_71075_bZ.field_75098_d) {
            if (this.isTeam()) {
                canEdit = (Boolean)Configuration.ACCESS_SETTINGS.lockTeamEdit.get() == false || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (!this.isPublic()) {
                canEdit = (Boolean)Configuration.ACCESS_SETTINGS.lockPersonalEdit.get() == false || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.func_110124_au().toString());
                msg = "private.denied";
            }
        }
        if (!canEdit && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "multistorage.chest." + msg);
        }
        return canEdit;
    }

    public boolean canUse(PlayerEntity player) {
        boolean canUse = true;
        String msg = "";
        if (!player.field_71075_bZ.field_75098_d) {
            if (this.isTeam()) {
                canUse = (Boolean)Configuration.ACCESS_SETTINGS.lockTeamUse.get() == false || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (this.isPublic()) {
                canUse = (Boolean)Configuration.ACCESS_SETTINGS.allowPublicChests.get();
                msg = "public.disabled";
            } else {
                canUse = (Boolean)Configuration.ACCESS_SETTINGS.lockPersonalUse.get() == false || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.func_110124_au().toString());
                msg = "private.denied";
            }
        }
        if (!canUse && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "multistorage.chest." + msg);
        }
        return canUse;
    }

    public boolean canLink(PlayerEntity player) {
        boolean canLink = true;
        String msg = "";
        if (!player.field_71075_bZ.field_75098_d) {
            if (this.isTeam()) {
                if (((Boolean)Configuration.ACCESS_SETTINGS.allowTeamBags.get()).booleanValue()) {
                    canLink = (Boolean)Configuration.ACCESS_SETTINGS.lockTeamLink.get() == false || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                    msg = "chest.team.denied";
                } else {
                    canLink = false;
                    msg = "bag.team.disabled";
                }
            } else if (!this.isPublic()) {
                if (((Boolean)Configuration.ACCESS_SETTINGS.allowPersonalBags.get()).booleanValue()) {
                    canLink = (Boolean)Configuration.ACCESS_SETTINGS.lockPersonalLink.get() == false || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.func_110124_au().toString());
                    msg = "chest.private.denied";
                } else {
                    canLink = false;
                    msg = "bag.private.disabled";
                }
            }
        }
        if (!canLink && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "multistorage." + msg);
        }
        return canLink;
    }

    private String getPlayerTeam(PlayerEntity player) {
        String team = Function.getPlayerTeamID((PlayerEntity)player);
        return "#" + (Strings.isNullOrEmpty((String)team) ? "none" : team);
    }

    public String getOwner() {
        return !Strings.isNullOrEmpty((String)this.owner) ? this.owner : "all";
    }

    public String getOwnerID() {
        if (this.getOwner().equalsIgnoreCase("all")) {
            return "all";
        }
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            return this.ownerID;
        }
        return this.getOwner();
    }

    public String getOwnerName() {
        return ChestInfoHelper.getDisplayNameFromOwnerID(this.ownerID);
    }

    public void setOwner(PlayerEntity player, ItemStack stack) {
        this.personalItem = stack;
        this.owner = player.func_145748_c_().getString();
        this.ownerID = player.func_110124_au().toString();
    }

    public void setOwner(String ownerName, String ownerID, ItemStack stack) {
        if (ownerID != null) {
            this.personalItem = stack;
            this.owner = ownerName;
            this.ownerID = ownerID;
        }
    }

    public ItemStack getPersonalItem() {
        if (this.personalItem != null) {
            if (this.personalItem.func_190916_E() != 1) {
                this.personalItem.func_190920_e(1);
            }
            return this.personalItem;
        }
        return null;
    }

    public boolean isPublic() {
        return this.getOwner().equalsIgnoreCase("all");
    }

    public boolean isTeam() {
        return this.ownerID != null && this.ownerID.startsWith("#");
    }

    public String getCode() {
        while (this.code.length() < 3) {
            this.code = "0" + this.code;
        }
        return this.code.toUpperCase();
    }

    public void setCode(String code) {
        while (code.length() < 3) {
            code = "0" + code;
        }
        this.code = code.toUpperCase();
    }

    public boolean hasError() {
        return !this.isPublic() && Strings.isNullOrEmpty((String)this.ownerID);
    }

    public RGB16 getRGB16(PlayerEntity player) {
        if (player == null) {
            return null;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return null;
        }
        int value = Integer.parseInt("" + this.getCode().charAt(ring), 16);
        return new RGB16(DyeColor.func_196056_a((int)value).func_176762_d());
    }

    public boolean setRGB16(short rgbIndex, PlayerEntity player) {
        return this.doColorRing(DyeColor.func_196056_a((int)RGB16Helper.getSimpleColor((short)rgbIndex)), player);
    }

    public boolean doColorRing(DyeColor color, PlayerEntity player) {
        if (player == null || !this.canEdit(player) || !((Boolean)Configuration.GENERAL.enableInWorldRecoloring.get()).booleanValue()) {
            return false;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return false;
        }
        char charColor = Integer.toHexString(color.func_196059_a()).charAt(0);
        char[] charCode = this.getCode().toCharArray();
        if (charCode[ring] != charColor) {
            charCode[ring] = charColor;
            this.setCode("" + charCode[0] + charCode[1] + charCode[2]);
            Function.syncTile((TileEntity)this);
            return true;
        }
        return false;
    }

    private int getRingHit(PlayerEntity player) {
        VoxelShape[] shapes = BlockEnderChest.SHAPES.get(this.func_195044_w().func_177229_b((Property)BlockEnderChest.FACING));
        return Function.getSubShapeHit((Entity)player, (BlockPos)this.func_174877_v(), (VoxelShape[])shapes) - 1;
    }

    private void setMyLocation() {
        if (this.func_145830_o() && !this.func_145831_w().field_72995_K) {
            LocationManager.set(this.getOwnerID(), this.getCode(), this);
        }
    }

    private void clearMyLocation() {
        if (this.func_145830_o() && !this.func_145831_w().field_72995_K) {
            LocationManager.clear(this.getOwnerID(), this.getCode(), this);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.setMyLocation();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.clearMyLocation();
    }
}

