/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.misc;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.MathHelper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.LocationManager;

class ChestData
extends InventoryInternal {
    private final String owner;
    private final String code;
    private byte capacity = (byte)9;

    ChestData(String owner, String code) {
        super(null, "", 54, 64, owner.toLowerCase() + "." + code.toLowerCase());
        this.owner = owner;
        this.code = code;
    }

    void setCapacity(byte capacity) {
        this.capacity = (byte)MathHelper.func_76125_a((int)capacity, (int)((Integer)Configuration.UPGRADE_SETTINGS.chestSizeMin.get()), (int)((Integer)Configuration.UPGRADE_SETTINGS.chestSizeMax.get()));
        ChestHelper.needsSaving = true;
        LocationManager.doBlockUpdate(this.owner, this.code);
    }

    CompoundNBT saveToNBT(CompoundNBT nbtTag) {
        ListNBT nbtList = new ListNBT();
        for (int index = 0; index < this.contents.length; ++index) {
            if (this.contents[index].func_190926_b()) continue;
            CompoundNBT nbtCompound = new CompoundNBT();
            nbtCompound.func_74774_a("Slot", (byte)index);
            this.contents[index].func_77955_b(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        nbtTag.func_218657_a("Items", (INBT)nbtList);
        nbtTag.func_74774_a("Capacity", this.capacity);
        return nbtTag;
    }

    ChestData loadFromNBT(CompoundNBT nbtTag) {
        this.func_174888_l();
        this.setCapacity(nbtTag.func_74771_c("Capacity"));
        ListNBT nbtList = nbtTag.func_150295_c("Items", 10);
        for (int index = 0; index < nbtList.size(); ++index) {
            CompoundNBT nbtCompound = nbtList.func_150305_b(index);
            int slot = nbtCompound.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.contents.length) continue;
            this.contents[slot] = ItemStack.func_199557_a((CompoundNBT)nbtCompound);
        }
        return this;
    }

    boolean saveCheck() {
        if (this.capacity > (Integer)Configuration.UPGRADE_SETTINGS.chestSizeMin.get()) {
            return true;
        }
        for (ItemStack content : this.contents) {
            if (content.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return MathHelper.func_76125_a((int)this.capacity, (int)((Integer)Configuration.UPGRADE_SETTINGS.chestSizeMin.get()), (int)((Integer)Configuration.UPGRADE_SETTINGS.chestSizeMax.get()));
    }

    public void func_70296_d() {
        ChestHelper.needsSaving = true;
        LocationManager.doBlockUpdate(this.owner, this.code);
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }
}

