/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.Localization;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.client.render.RenderRegistry;

public class ItemEnderPouch
extends Item {
    private static final ITextComponent VANILLA_ENDER_CHEST_NAME = new TranslationTextComponent("container.enderchest");

    public ItemEnderPouch(Item.Properties properties) {
        super(properties);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.OVERRIDES.add((Triple<Item, String, IItemPropertyGetter>)Triple.of((Object)((Object)this), (Object)"open", (stack, world, entity) -> ItemEnderPouch.isOpen(stack) ? 1.0f : 0.0f)));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            list.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        ItemEnderPouch.setOpenState(stack, false);
    }

    public static boolean isOpen(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("open")) {
            return tag.func_74767_n("open");
        }
        ItemEnderPouch.setOpenState(stack, false);
        return false;
    }

    private static void setOpenState(ItemStack stack, boolean isOpen) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74757_a("open", isOpen);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (((Boolean)Configuration.ACCESS_SETTINGS.allowEnderPouch.get()).booleanValue()) {
            if (!ItemEnderPouch.isOpen(stack)) {
                ItemEnderPouch.setOpenState(stack, true);
            }
            player.func_184185_a(SoundEvents.field_187719_p, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((id, invPlayer, entity) -> ChestContainer.func_216992_a((int)id, (PlayerInventory)invPlayer, (IInventory)invPlayer.field_70458_d.func_71005_bN()), VANILLA_ENDER_CHEST_NAME));
                player.func_195066_a(Stats.field_188090_X);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (ItemEnderPouch.isOpen(stack)) {
            Container container;
            if (isSelected && entity instanceof PlayerEntity && (container = ((PlayerEntity)entity).field_71070_bA) instanceof ChestContainer) {
                return;
            }
            ItemEnderPouch.setOpenState(stack, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advancedTooltips) {
        if (!((Boolean)Configuration.ACCESS_SETTINGS.allowEnderPouch.get()).booleanValue()) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a7o" + Localization.get((String)"info.enderchests.craftingmaterial.txt")));
        }
    }
}

