/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.misc;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import shetiphian.core.client.Localization;
import shetiphian.core.common.NameHelper;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ChestInfoHelper {
    private static final ChestInfoHelper INSTANCE = new ChestInfoHelper();

    public static void getHUDInfo(List<String> tooltip, TileEntityEnderChest tile) {
        if (tile == null) {
            return;
        }
        tooltip.add(ChestInfoHelper.formatChestOwner(tile.getOwnerName(), true));
        tooltip.add(" " + Localization.get((String)"info.enderchests.chest.code.txt") + " " + tile.getCode());
    }

    public static void sendCapacityInfo(PlayerEntity player, TileEntityEnderChest tankTile) {
        String message = INSTANCE.localize("info.enderchests.chest.capacity.txt");
        message = message + " " + ChestHelper.getCapacity(player.func_130014_f_(), tankTile.getOwnerID(), tankTile.getCode());
        INSTANCE.sendInfo(player, message);
    }

    public static void sendLinkError(PlayerEntity player, int error) {
        String message = "\u00a7c\u00a7l" + INSTANCE.localize("error.enderchests.bag.nolink" + error + ".txt") + "\u00a7r";
        INSTANCE.sendInfo(player, message);
    }

    public static void sendError(PlayerEntity player, String error) {
        String message = "\u00a7c\u00a7l" + INSTANCE.localize("error." + error + ".txt") + "\u00a7r";
        INSTANCE.sendInfo(player, message);
    }

    public static String formatChestOwner(String owner, boolean displayPublic) {
        if (Strings.isNullOrEmpty((String)owner) || owner.equalsIgnoreCase("all")) {
            return displayPublic ? " \u00a76[-" + INSTANCE.localize("info.enderchests.chest.public.txt") + "-]\u00a7r" : "";
        }
        if (owner.startsWith("#")) {
            return " \u00a7a[-" + owner.substring(1) + "\u00a7a-]\u00a7r";
        }
        return " \u00a7b[-" + owner + "\u00a7b-]\u00a7r";
    }

    private String localize(String string) {
        return Localization.get((String)string);
    }

    private void sendInfo(PlayerEntity player, String message) {
        if (player instanceof ServerPlayerEntity) {
            message = message.replace("<br>", " ");
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChatPacket((ITextComponent)new StringTextComponent(message), ChatType.GAME_INFO, player.func_110124_au()));
        } else {
            String[] split;
            for (String line : split = message.split("<br>")) {
                player.func_146105_b((ITextComponent)new StringTextComponent(line), true);
            }
        }
    }

    public static String getDisplayNameFromOwnerID(String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            return "all";
        }
        if (ownerID.startsWith("#")) {
            return "#" + NameHelper.getDisplayNameFor((String)ownerID.substring(1));
        }
        return NameHelper.getDisplayNameFor((String)ownerID);
    }
}

