/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.client.render.RenderRegistry;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.inventory.ContainerProviders;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.misc.StackHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ItemEnderBag
extends Item
implements IColored {
    public ItemEnderBag(Item.Properties properties) {
        super(properties);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            RenderRegistry.OVERRIDES.add((Triple<Item, String, IItemPropertyGetter>)Triple.of((Object)((Object)this), (Object)"type", (stack, world, entity) -> StackHelper.isPublic(stack) ? 0.0f : (StackHelper.isTeam(stack) ? 2.0f : 1.0f)));
            RenderRegistry.OVERRIDES.add((Triple<Item, String, IItemPropertyGetter>)Triple.of((Object)((Object)this), (Object)"open", (stack, world, entity) -> ItemEnderBag.isOpen(stack) ? 1.0f : 0.0f));
        });
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            for (String code : StackHelper.BASE_CODES) {
                list.add((Object)StackHelper.create(this, code, null));
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        if (!((Boolean)Configuration.ACCESS_SETTINGS.allowPublicBags.get()).booleanValue() && StackHelper.isPublic(stack)) {
            if (!((Boolean)Configuration.ACCESS_SETTINGS.allowPersonalBags.get()).booleanValue()) {
                String teamID = Function.getPlayerTeamID((PlayerEntity)player);
                if (!Strings.isNullOrEmpty((String)teamID)) {
                    StackHelper.setOwner(stack, "#" + teamID);
                }
            } else {
                StackHelper.setOwner(stack, player.func_110124_au().toString());
            }
        }
        ItemEnderBag.setOpenState(stack, false);
    }

    public static boolean isOpen(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("open")) {
            return tag.func_74767_n("open");
        }
        ItemEnderBag.setOpenState(stack, false);
        return false;
    }

    private static void setOpenState(ItemStack stack, boolean isOpen) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74757_a("open", isOpen);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        BlockPos pos;
        ItemStack stack = player.func_184586_b(hand);
        boolean isSneaking = player.func_213453_ef();
        BlockRayTraceResult mop = ItemEnderBag.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        BlockPos blockPos = pos = mop instanceof BlockRayTraceResult ? mop.func_216350_a() : null;
        if (isSneaking && pos != null && world.func_180495_p(pos).func_177230_c() == Values.blockEnderChest) {
            TileEntityEnderChest chestTile = (TileEntityEnderChest)world.func_175625_s(pos);
            if (chestTile.hasError()) {
                if (!world.field_72995_K) {
                    ChestInfoHelper.sendLinkError(player, 2);
                }
            } else {
                if (chestTile.canLink(player)) {
                    return new ActionResult(ActionResultType.SUCCESS, (Object)StackHelper.create(this, chestTile.getCode(), chestTile.getOwnerID()));
                }
                if (!world.field_72995_K) {
                    ChestInfoHelper.sendLinkError(player, chestTile.isTeam() ? 3 : 1);
                }
            }
        }
        if (!StackHelper.isPublic(stack) || ((Boolean)Configuration.ACCESS_SETTINGS.allowPublicBags.get()).booleanValue()) {
            if (!world.field_72995_K) {
                String ownerID = StackHelper.getOwnerID(stack);
                String code = StackHelper.getCode(stack);
                if (Strings.isNullOrEmpty((String)ownerID) || Strings.isNullOrEmpty((String)code)) {
                    ChestInfoHelper.sendError(player, "enderchests.bag.corrupted");
                } else {
                    String ownerName = StackHelper.getOwnerName(stack);
                    CompoundNBT dataTag = new CompoundNBT();
                    dataTag.func_74778_a("owner.id", ownerID);
                    dataTag.func_74778_a("code", code);
                    dataTag.func_74778_a("owner.name", ownerName);
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProviders.EnderBag(stack, ownerName, code), buf -> {
                        buf.func_180714_a(ownerID);
                        buf.func_180714_a(code);
                        buf.func_180714_a(ownerName);
                    });
                    ItemEnderBag.setOpenState(stack, true);
                    player.func_184185_a(SoundEvents.field_187719_p, 1.0f, 1.0f);
                }
            }
        } else {
            ChestInfoHelper.sendError(player, "enderchests.bag.public.disabled");
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (ItemEnderBag.isOpen(stack)) {
            if (isSelected && entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71070_bA instanceof ContainerEnderChest) {
                return;
            }
            ItemEnderBag.setOpenState(stack, false);
        }
    }

    public String func_77667_c(ItemStack stack) {
        return "item.enderchests.bag." + (StackHelper.isPublic(stack) ? "public" : (StackHelper.isTeam(stack) ? "team" : "private"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advancedTooltips) {
        tooltip.add((ITextComponent)new StringTextComponent(" " + Localization.get((String)"info.enderchests.chest.code.txt") + " " + StackHelper.getCode(stack)));
        String owner = ChestInfoHelper.formatChestOwner(StackHelper.getOwnerName(stack), false);
        if (!Strings.isNullOrEmpty((String)owner)) {
            tooltip.add((ITextComponent)new StringTextComponent(owner));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && !data.stack.func_190926_b()) {
            int value = MathHelper.func_76125_a((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }
}

