/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.Localization;
import shetiphian.core.common.IColored;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.client.render.RenderRegistry;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.misc.StackHelper;

public class ItemBlockEnderChest
extends BlockItem
implements IColored {
    public ItemBlockEnderChest(Block block, Item.Properties properties) {
        super(block, properties);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.OVERRIDES.add((Triple<Item, String, IItemPropertyGetter>)Triple.of((Object)((Object)this), (Object)"type", (stack, world, entity) -> StackHelper.isPublic(stack) ? 0.0f : (StackHelper.isTeam(stack) ? 2.0f : 1.0f))));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            for (String code : StackHelper.BASE_CODES) {
                list.add((Object)StackHelper.create((Item)this, code, null));
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        super.func_77622_d(stack, world, player);
        StackHelper.getCode(stack);
        StackHelper.getOwnerID(stack);
    }

    public String func_77667_c(ItemStack stack) {
        return "block.enderchests.chest." + (StackHelper.isPublic(stack) ? "public" : (StackHelper.isTeam(stack) ? "team" : "private"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advancedTooltips) {
        tooltip.add((ITextComponent)new StringTextComponent(" " + Localization.get((String)"info.enderchests.chest.code.txt") + " " + StackHelper.getCode(stack)));
        String owner = ChestInfoHelper.formatChestOwner(StackHelper.getOwnerName(stack), false);
        if (!Strings.isNullOrEmpty((String)owner)) {
            tooltip.add((ITextComponent)new StringTextComponent(owner));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && data.stack != null) {
            int value = MathHelper.func_76125_a((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }
}

