/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

@OnlyIn(value=Dist.CLIENT)
public class RenderEnderChest
extends TileEntityRenderer<TileEntityEnderChest> {
    private static final BlockModelRenderer RENDERER = new BlockModelRenderer(Minecraft.func_71410_x().func_184125_al());

    public RenderEnderChest(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(TileEntityEnderChest tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockPos pos = tile.func_174877_v();
        ChunkRenderCache world = MinecraftForgeClient.getRegionRenderCache((World)tile.func_145831_w(), (BlockPos)pos);
        BlockState state = tile.func_195044_w();
        if (world == null || !state.func_235901_b_((Property)BlockEnderChest.STATIC)) {
            return;
        }
        state = (BlockState)state.func_206870_a((Property)BlockEnderChest.STATIC, (Comparable)Boolean.valueOf(false));
        float lidAngle = tile.getLidAngle(partialTicks);
        lidAngle *= 0.7f;
        IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
        Direction facing = BlockEnderChest.getFacing(state);
        if (facing.func_176743_c() == Direction.AxisDirection.POSITIVE) {
            lidAngle = -lidAngle;
        }
        matrixStack.func_227860_a_();
        switch (facing.func_176740_k()) {
            case X: {
                matrixStack.func_227861_a_((double)lidAngle, 0.0, 0.0);
                break;
            }
            case Y: {
                matrixStack.func_227861_a_(0.0, (double)lidAngle, 0.0);
                break;
            }
            case Z: {
                matrixStack.func_227861_a_(0.0, 0.0, (double)lidAngle);
            }
        }
        RENDERER.renderModel((IBlockDisplayReader)world, model, state, pos, matrixStack, buffer.getBuffer(Atlases.func_228783_h_()), false, new Random(), 0L, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.func_227865_b_();
    }
}

