/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.GuiFunctions;
import shetiphian.enderchests.client.gui.Textures;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.inventory.Slots;
import shetiphian.enderchests.common.item.ItemEnderBag;

@OnlyIn(value=Dist.CLIENT)
public class GuiEnderChest
extends ContainerScreen<ContainerEnderChest> {
    private int slotCount;
    private int columns;
    private int rows;
    private int colOffset;

    public GuiEnderChest(ContainerEnderChest container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.field_146999_f = 182;
        this.setLayout();
        ((ContainerEnderChest)this.field_147002_h).setInventoryChangeCallback(this::setLayout);
    }

    private void setLayout() {
        this.slotCount = ((ContainerEnderChest)this.field_147002_h).getChestSize();
        int n = this.columns = this.slotCount >= 27 ? 9 : this.slotCount / 3;
        this.rows = this.slotCount <= 27 ? 3 : (this.slotCount % 9 == 0 ? this.slotCount / 9 : this.slotCount / 9 + 1);
        this.colOffset = (9 - this.columns) * 9;
        int rowOffset = (this.rows - 3) * 18;
        this.field_147000_g = 172 + rowOffset;
        this.field_147009_r = (this.field_230709_l_ - this.field_147000_g) / 2;
        for (Slot invSlot : ((ContainerEnderChest)this.field_147002_h).field_75151_b) {
            if (invSlot instanceof Slots.Hideable) {
                Slots.Hideable slot = (Slots.Hideable)invSlot;
                int group = slot.getSlotIndex();
                if (slot.getSlotIndex() >= this.slotCount) {
                    slot.setVisible(false);
                    continue;
                }
                slot.setVisible(true);
                int toX = 11 + this.colOffset + group % this.columns * 18;
                int toY = 11 + group / this.columns * 18;
                Slots.moveSlot(slot, toX, toY);
                continue;
            }
            int slotId = invSlot.getSlotIndex();
            int row = slotId / 9 - 1;
            int col = slotId % 9 * 18;
            Slots.moveSlot(invSlot, 11 + col, 87 + rowOffset + (row == -1 ? 58 : row * 18));
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        GuiEnderChest.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)((ContainerEnderChest)this.field_147002_h).getOwner(), (int)(this.field_146999_f / 2), (int)-8, (int)-32961);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        if (this.slotCount != ((ContainerEnderChest)this.field_147002_h).getChestSize()) {
            this.setLayout();
        }
        GuiFunctions.enterDrawTextureStateWithBlend();
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(Textures.ENDERCHEST.get());
        int ypos = 0;
        if (this.slotCount >= 27) {
            int rem;
            this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r + ypos, 0, 102, 182, 46);
            this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r + (ypos += 46), 0, 112, 182, this.rows == 3 ? 18 : 36);
            ypos += this.rows == 3 ? 18 : 36;
            if (this.rows > 4) {
                this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r + ypos, 0, 112, 182, this.rows == 5 ? 18 : 36);
                ypos += this.rows == 5 ? 18 : 36;
            }
            if ((rem = this.slotCount % 9) != 0) {
                int left = rem == 3 ? 64 : 118;
                this.func_238474_b_(matrixStack, this.field_147003_i + left, this.field_147009_r + ypos - 18, left, this.rows % 2 == 0 ? 82 : 64, 182 - left - 10, 18);
            }
            this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r + ypos, 0, 148, 182, 10);
        } else {
            int left = this.colOffset;
            this.func_238474_b_(matrixStack, this.field_147003_i + left, this.field_147009_r, 0, 102, 10, 46);
            this.func_238474_b_(matrixStack, this.field_147003_i + left, this.field_147009_r + 46, 0, 112, 10, 18);
            this.func_238474_b_(matrixStack, this.field_147003_i + left, this.field_147009_r + 64, 0, 148, 10, 10);
            int half = (this.columns / 2 - 1) * 18;
            this.func_238474_b_(matrixStack, this.field_147003_i + (left += 10), this.field_147009_r, 64 - half, 102, this.columns * 18, 46);
            this.func_238474_b_(matrixStack, this.field_147003_i + left, this.field_147009_r + 46, 64 - half, 112, this.columns * 18, 18);
            this.func_238474_b_(matrixStack, this.field_147003_i + left, this.field_147009_r + 64, 64 - half, 148, this.columns * 18, 10);
            this.func_238474_b_(matrixStack, this.field_147003_i + (left += this.columns * 18), this.field_147009_r, 172, 102, 10, 46);
            this.func_238474_b_(matrixStack, this.field_147003_i + left, this.field_147009_r + 46, 172, 112, 10, 18);
            this.func_238474_b_(matrixStack, this.field_147003_i + left, this.field_147009_r + 64, 172, 148, 10, 10);
            ypos += 64;
        }
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r + (ypos += 10), 0, 158, 182, 98);
        GuiFunctions.exitDrawTextureStateWithBlend();
    }

    protected void func_184098_a(Slot slot, int slotId, int clickedButton, ClickType clickType) {
        ItemStack stack;
        if (slot != null && slot.func_75216_d() && !(stack = slot.func_75211_c()).func_190926_b() && stack.func_77973_b() instanceof ItemEnderBag && ItemEnderBag.isOpen(stack)) {
            return;
        }
        super.func_184098_a(slot, slotId, clickedButton, clickType);
    }
}

