/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.earth;

import java.util.ArrayDeque;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import sirttas.elementalcraft.loot.LootHelper;
import sirttas.elementalcraft.spell.Spell;

public class SilkVeinSpell
extends Spell {
    public static final String NAME = "silk_vein";

    private boolean isValidBlock(Block block) {
        return Tags.Blocks.ORES.func_230235_a_((Object)block);
    }

    private void mineVein(Entity sender, World world, BlockPos target) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        float rangeSq = this.getRange(sender);
        rangeSq *= rangeSq;
        queue.offer(target);
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!this.isValidBlock(block) || !(pos.func_177951_i((Vector3i)target) <= (double)rangeSq)) continue;
            if (world instanceof ServerWorld) {
                LootHelper.getDrops((ServerWorld)world, pos, true).forEach(stack -> Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack));
            }
            world.func_175655_b(pos, false);
            Stream.of(Direction.values()).forEach(d -> queue.offer(pos.func_177972_a(d)));
        }
    }

    @Override
    public ActionResultType castOnBlock(Entity sender, BlockPos target) {
        World world = sender.func_130014_f_();
        if (!world.field_72995_K && this.isValidBlock(world.func_180495_p(target).func_177230_c())) {
            this.mineVein(sender, world, target);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

