/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.air;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import sirttas.elementalcraft.spell.Spell;

public class TranslocationSpell
extends Spell {
    public static final String NAME = "translocation";

    private void teleport(Entity sender, Vector3d newPos) {
        sender.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
    }

    @Override
    public ActionResultType castOnSelf(Entity sender) {
        World world = sender.func_130014_f_();
        Vector3d look = sender.func_70040_Z();
        Vector3d tagetPos = sender.func_213303_ch().func_178787_e(new Vector3d(look.func_82615_a(), 0.0, look.func_82616_c()).func_72432_b().func_186678_a((double)this.getRange(sender)));
        Vector3d newPos = new Vector3d(tagetPos.func_82615_a(), this.getHeight(world, sender, tagetPos), tagetPos.func_82616_c());
        if (world.func_212866_a_((int)Math.round(newPos.field_72450_a) >> 4, (int)Math.round(newPos.field_72449_c) >> 4) == null) {
            return ActionResultType.FAIL;
        }
        if (sender instanceof LivingEntity) {
            LivingEntity livingSender = (LivingEntity)sender;
            if (MinecraftForge.EVENT_BUS.post((Event)new EnderTeleportEvent(livingSender, newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c, 0.0f))) {
                return ActionResultType.SUCCESS;
            }
            this.teleport(sender, newPos);
            livingSender.func_130014_f_().func_184148_a(null, livingSender.field_70169_q, livingSender.field_70167_r, livingSender.field_70166_s, SoundEvents.field_187534_aX, livingSender.func_184176_by(), 1.0f, 1.0f);
            livingSender.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        } else {
            this.teleport(sender, newPos);
        }
        return ActionResultType.SUCCESS;
    }

    private double getHeight(World world, Entity sender, Vector3d tagetPos) {
        double height = (double)world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(tagetPos)).func_177956_o() + 1.0;
        if (!sender.func_233570_aj_()) {
            return Math.max(height, sender.func_226278_cu_());
        }
        return height;
    }
}

