/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import sirttas.elementalcraft.network.message.MessageHelper;
import sirttas.elementalcraft.spell.AbstractSpellInstance;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellTickCooldownMessage;

public class SpellTickManager {
    public static final SpellTickManager SERVER_INSTANCE = new SpellTickManager();
    public static final SpellTickManager CLIENT_INSTANCE = new SpellTickManager();
    private int tick = 0;
    private Map<Entity, Map<Spell, Cooldown>> cooldowns = new HashMap<Entity, Map<Spell, Cooldown>>();
    private List<AbstractSpellInstance> spellinstances = Lists.newArrayList();

    private SpellTickManager() {
    }

    public static SpellTickManager getInstance(World world) {
        return world.field_72995_K ? CLIENT_INSTANCE : SERVER_INSTANCE;
    }

    private void tick() {
        ++this.tick;
        this.cooldowns.keySet().removeIf(e -> !e.func_70089_S());
        this.cooldowns.forEach((k, v) -> v.values().removeIf(c -> ((Cooldown)c).expireTicks <= this.tick));
        if (this.cooldowns.isEmpty()) {
            this.tick = 0;
        }
        this.spellinstances.forEach(i -> {
            i.tick();
            i.decTick();
        });
        this.spellinstances.removeIf(AbstractSpellInstance::isFinished);
    }

    public void addSpellInstance(AbstractSpellInstance instance) {
        this.spellinstances.add(instance);
    }

    public void setCooldown(Entity target, Spell spell) {
        Map<Object, Object> entityCooldowns;
        Cooldown cooldown = new Cooldown(this.tick, this.tick + spell.getCooldown());
        if (!this.cooldowns.containsKey(target)) {
            entityCooldowns = new HashMap();
            this.cooldowns.put(target, entityCooldowns);
        } else {
            entityCooldowns = this.cooldowns.get(target);
        }
        entityCooldowns.put(spell, cooldown);
        if (!target.field_70170_p.field_72995_K && target instanceof ServerPlayerEntity) {
            MessageHelper.sendToPlayer((ServerPlayerEntity)target, new SpellTickCooldownMessage(spell));
        }
    }

    public boolean hasCooldown(Entity target, Spell spell) {
        return this.getCooldown(target, spell) > 0.0f;
    }

    public float getCooldown(Entity target, Spell spell) {
        return this.getCooldown(target, spell, 0.0f);
    }

    public float getCooldown(Entity target, Spell spell, float partialTick) {
        Map<Spell, Cooldown> entityCooldowns = this.cooldowns.get(target);
        if (spell.isValid() && entityCooldowns != null && entityCooldowns.containsKey(spell)) {
            Cooldown cooldown = entityCooldowns.get(spell);
            float current = (float)cooldown.expireTicks - ((float)this.tick + partialTick);
            float total = (float)cooldown.expireTicks - (float)cooldown.createTicks;
            return current / total;
        }
        return 0.0f;
    }

    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            SERVER_INSTANCE.tick();
        }
    }

    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            CLIENT_INSTANCE.tick();
        }
    }

    private static class Cooldown {
        private final int createTicks;
        private final int expireTicks;

        private Cooldown(int createTicksIn, int expireTicksIn) {
            this.createTicks = createTicksIn;
            this.expireTicks = expireTicksIn;
        }
    }
}

