/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellTickManager;

public class SpellTickCooldownMessage {
    private final Spell spell;

    public SpellTickCooldownMessage(Spell spell) {
        this.spell = spell;
    }

    public static SpellTickCooldownMessage decode(PacketBuffer buf) {
        return new SpellTickCooldownMessage((Spell)Spell.REGISTRY.getValue(buf.func_192575_l()));
    }

    public void encode(PacketBuffer buf) {
        buf.func_192572_a(this.spell.getRegistryName());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                this.setCooldown();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setCooldown() {
        SpellTickManager.CLIENT_INSTANCE.setCooldown((Entity)Minecraft.func_71410_x().field_71439_g, this.spell);
    }
}

