/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.block.evaporator.EvaporatorBlock;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerBlockEntity;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.elemental.ShardItem;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;

public class CrystallizationRecipe
extends AbstractInstrumentRecipe<CrystallizerBlockEntity> {
    public static final String NAME = "crystallization";
    public static final IRecipeType<CrystallizationRecipe> TYPE = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)ElementalCraft.createRL("crystallization"), (Object)new IRecipeType<CrystallizationRecipe>(){

        public String toString() {
            return CrystallizationRecipe.NAME;
        }
    });
    @ObjectHolder(value="elementalcraft:crystallization")
    public static final IRecipeSerializer<CrystallizationRecipe> SERIALIZER = null;
    private final NonNullList<Ingredient> ingredients;
    private final List<ResultEntry> outputs;
    private final int elementAmount;

    public CrystallizationRecipe(ResourceLocation id, ElementType type, int elementAmount, List<ResultEntry> outputs, List<Ingredient> ingredients) {
        super(id, type);
        this.ingredients = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])ingredients.stream().toArray(Ingredient[]::new));
        this.outputs = ImmutableList.copyOf(outputs);
        this.elementAmount = elementAmount;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public boolean matches(CrystallizerBlockEntity inv) {
        if (inv.getTankElementType() == this.getElementType() && inv.getItemCount() >= 2) {
            for (int i = 0; i < 2; ++i) {
                if (((Ingredient)this.ingredients.get(i)).test(inv.getInventory().func_70301_a(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean func_192399_d() {
        return true;
    }

    public List<ResultEntry> getOutputs() {
        return this.outputs;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    @Override
    public void process(CrystallizerBlockEntity instrument) {
        int luck = (int)Math.round((double)instrument.getRuneHandler().getBonus(Rune.BonusType.LUCK) * (Double)ECConfig.COMMON.crystallizerLuckRatio.get());
        IInventory inv = instrument.getInventory();
        for (int i = 2; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (EvaporatorBlock.getShardElementType(stack) != this.elementType) continue;
            luck += ((ShardItem)stack.func_77973_b()).getElementAmount();
        }
        ItemStack gem = instrument.getInventory().func_70301_a(0);
        instrument.func_174888_l();
        instrument.getInventory().func_70299_a(0, this.assemble(gem, instrument, luck));
    }

    @Override
    public ItemStack assemble(CrystallizerBlockEntity instrument) {
        return this.assemble(instrument.getInventory().func_70301_a(0), instrument, 0.0f);
    }

    private ItemStack assemble(ItemStack gem, CrystallizerBlockEntity instrument, float luck) {
        int index = IntStream.range(0, this.outputs.size()).filter(i -> ItemHandlerHelper.canItemStacksStack((ItemStack)this.outputs.get(i).result, (ItemStack)gem)).findFirst().orElse(-1);
        List<ResultEntry> list = this.outputs.subList(index + 1, this.outputs.size());
        int weight = this.getTotalWeight(list, luck);
        if (weight > 0) {
            int roll = Math.min(instrument.func_145831_w().field_73012_v.nextInt(weight), weight - 1);
            for (ResultEntry entry : this.outputs) {
                if ((roll -= entry.getEffectiveWeight(luck)) >= 0) continue;
                return entry.getResult();
            }
        }
        return gem;
    }

    public int getTotalWeight() {
        return this.getTotalWeight(this.outputs, 0.0f);
    }

    public int getTotalWeight(List<ResultEntry> list, float luck) {
        return list.stream().mapToInt(result -> result.getEffectiveWeight(luck)).sum();
    }

    public float getWeight(ItemStack stack) {
        return this.outputs.stream().filter(r -> ItemHandlerHelper.canItemStacksStack((ItemStack)((ResultEntry)r).result, (ItemStack)stack)).findAny().map(r -> Float.valueOf(((ResultEntry)r).weight)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static ResultEntry createResult(ItemStack result, float weight) {
        return CrystallizationRecipe.createResult(result, weight, 1.0f);
    }

    public static ResultEntry createResult(ItemStack result, float weight, float quality) {
        return new ResultEntry(result, weight, quality);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CrystallizationRecipe> {
        private static final Codec<List<ResultEntry>> OUTPUT_CODEC = ResultEntry.LIST_CODEC.fieldOf("outputs").codec();

        public CrystallizationRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ElementType type = ElementType.byName(JSONUtils.func_151200_h((JsonObject)json, (String)"element_type"));
            int elementAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"element_amount");
            NonNullList<Ingredient> ingredients = Serializer.readIngredients(JSONUtils.func_152754_s((JsonObject)json, (String)"ingredients"));
            List outputs = (List)CodecHelper.decode(ResultEntry.LIST_CODEC, (JsonElement)json.get("outputs"));
            return new CrystallizationRecipe(recipeId, type, elementAmount, outputs, (List<Ingredient>)ingredients);
        }

        public static NonNullList<Ingredient> readIngredients(JsonObject json) {
            NonNullList list = NonNullList.func_191196_a();
            list.add((Object)RecipeHelper.deserializeIngredient(json, "gem"));
            list.add((Object)RecipeHelper.deserializeIngredient(json, "crystal"));
            list.add((Object)RecipeHelper.deserializeIngredient(json, "shard"));
            return list;
        }

        public CrystallizationRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            ElementType type = ElementType.byName(buffer.func_218666_n());
            int elementAmount = buffer.readInt();
            List outputs = (List)CodecHelper.decode(OUTPUT_CODEC, (PacketBuffer)buffer);
            int i = buffer.readInt();
            NonNullList ingredients = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < i; ++j) {
                ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            return new CrystallizationRecipe(recipeId, type, elementAmount, outputs, (List<Ingredient>)ingredients);
        }

        public void toNetwork(PacketBuffer buffer, CrystallizationRecipe recipe) {
            buffer.func_180714_a(recipe.getElementType().func_176610_l());
            buffer.writeInt(recipe.getElementAmount());
            CodecHelper.encode(OUTPUT_CODEC, (Object)recipe.outputs, (PacketBuffer)buffer);
            buffer.writeInt(recipe.func_192400_c().size());
            recipe.func_192400_c().forEach(ingredient -> ingredient.func_199564_a(buffer));
        }
    }

    public static class ResultEntry {
        public static final Codec<ResultEntry> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.field_234691_a_.fieldOf("result").forGetter(r -> r.result), (App)Codec.FLOAT.fieldOf("weight").forGetter(r -> Float.valueOf(r.weight)), (App)Codec.FLOAT.optionalFieldOf("quality", (Object)Float.valueOf(1.0f)).forGetter(r -> Float.valueOf(r.quality))).apply((Applicative)builder, ResultEntry::new));
        public static final Codec<List<ResultEntry>> LIST_CODEC = CODEC.listOf();
        private final float weight;
        private final float quality;
        private final ItemStack result;

        private ResultEntry(ItemStack result, float weight, float quality) {
            this.result = result;
            this.weight = weight;
            this.quality = quality;
        }

        public ItemStack getResult() {
            return this.result.func_77946_l();
        }

        public int getEffectiveWeight(float luck) {
            return Math.max(MathHelper.func_76141_d((float)(this.weight + this.quality * luck)), 0);
        }
    }
}

