/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.recipe.IECRecipe;
import sirttas.elementalcraft.recipe.RecipeHelper;

public class SpellCraftRecipe
implements IECRecipe<IInventory> {
    public static final String NAME = "spell_craft";
    public static final IRecipeType<SpellCraftRecipe> TYPE = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)ElementalCraft.createRL("spell_craft"), (Object)new IRecipeType<SpellCraftRecipe>(){

        public String toString() {
            return SpellCraftRecipe.NAME;
        }
    });
    @ObjectHolder(value="elementalcraft:spell_craft")
    public static final IRecipeSerializer<SpellCraftRecipe> SERIALIZER = null;
    private static final Ingredient SCROLL_PAPER = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.SCROLL_PAPER});
    private final Ingredient gem;
    private final Ingredient crystal;
    private final ItemStack output;
    private final ResourceLocation id;

    public SpellCraftRecipe(ResourceLocation id, ItemStack output, Ingredient gem, Ingredient crystal) {
        this.id = id;
        this.output = output;
        this.gem = gem;
        this.crystal = crystal;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return SCROLL_PAPER.test(inv.func_70301_a(0)) && this.gem.test(inv.func_70301_a(1)) && this.crystal.test(inv.func_70301_a(2));
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{SCROLL_PAPER, this.gem, this.crystal});
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<SpellCraftRecipe> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<SpellCraftRecipe> func_222127_g() {
        return TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SpellCraftRecipe> {
        public SpellCraftRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient gem = Ingredient.func_199802_a((JsonElement)json.get("gem"));
            Ingredient crystal = Ingredient.func_199802_a((JsonElement)json.get("crystal"));
            ItemStack output = RecipeHelper.readRecipeOutput(json, "output");
            return new SpellCraftRecipe(recipeId, output, gem, crystal);
        }

        public SpellCraftRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient gem = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient crystal = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack output = buffer.func_150791_c();
            return new SpellCraftRecipe(recipeId, output, gem, crystal);
        }

        public void toNetwork(PacketBuffer buffer, SpellCraftRecipe recipe) {
            recipe.gem.func_199564_a(buffer);
            recipe.crystal.func_199564_a(buffer);
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

