/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.network.message;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.network.message.MessageHandler;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.tag.ECTags;

public final class ECMessage {
    public static final ECMessage SCROLL_FORWARD = new ECMessage(MessageType.SCROLL_FORWARD);
    public static final ECMessage SCROLL_BACKWORD = new ECMessage(MessageType.SCROLL_BACKWORD);
    private MessageType type = null;

    private ECMessage() {
    }

    private ECMessage(MessageType type) {
        this.type = type;
    }

    public static ECMessage decode(PacketBuffer buf) {
        return new ECMessage((MessageType)buf.func_179257_a(MessageType.class));
    }

    public void encode(PacketBuffer buf) {
        buf.func_179249_a((Enum)this.type);
    }

    private void handelScroll(ServerPlayerEntity player, int delta) {
        EntityHelper.handStream((PlayerEntity)player).filter(i -> i.func_77973_b().func_206844_a(ECTags.Items.SPELL_CAST_TOOLS)).findFirst().ifPresent(i -> SpellHelper.moveSelected(i, delta));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            switch (this.type) {
                case SCROLL_BACKWORD: {
                    this.handelScroll(player, -1);
                    break;
                }
                case SCROLL_FORWARD: {
                    this.handelScroll(player, 1);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void send() {
        MessageHandler.CHANNEL.sendToServer((Object)this);
    }

    public static enum MessageType {
        SCROLL_FORWARD,
        SCROLL_BACKWORD;

    }
}

