/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot.function;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;

public class RandomSpell
extends LootFunction {
    private ElementType elementType;
    private final List<Spell> spellList;
    static LootFunctionType type;

    private RandomSpell(ILootCondition[] condition, Collection<Spell> spellList) {
        super(condition);
        this.spellList = ImmutableList.copyOf(spellList);
        this.elementType = ElementType.NONE;
    }

    private RandomSpell(ILootCondition[] condition, ElementType elementType) {
        this(condition, (Collection<Spell>)ImmutableList.of());
        this.elementType = elementType;
    }

    public ItemStack func_215859_a(ItemStack stack, LootContext context) {
        Random random = context.func_216032_b();
        Spell spell = !this.spellList.isEmpty() ? SpellHelper.randomSpell(this.spellList, random) : (this.elementType != ElementType.NONE ? SpellHelper.randomSpell(this.elementType, random) : SpellHelper.randomSpell(random));
        SpellHelper.setSpell(stack, spell);
        return stack;
    }

    public static LootFunction.Builder<?> builder() {
        return RandomSpell.builder((Collection<Spell>)ImmutableList.of());
    }

    public static LootFunction.Builder<?> builder(Collection<Spell> spellList) {
        return RandomSpell.func_215860_a(l -> new RandomSpell((ILootCondition[])l, spellList));
    }

    public static LootFunction.Builder<?> builder(ElementType elementType) {
        return RandomSpell.func_215860_a(l -> new RandomSpell((ILootCondition[])l, elementType));
    }

    public LootFunctionType func_230425_b_() {
        return type;
    }

    public static class Serializer
    extends LootFunction.Serializer<RandomSpell> {
        public void serialize(JsonObject object, RandomSpell function, JsonSerializationContext serializationContext) {
            super.func_230424_a_(object, (LootFunction)function, serializationContext);
            if (!function.spellList.isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (Spell spell : function.spellList) {
                    ResourceLocation resourcelocation = Spell.REGISTRY.getKey((IForgeRegistryEntry)spell);
                    if (resourcelocation == null) {
                        throw new IllegalArgumentException("Don't know how to serialize spell " + spell);
                    }
                    jsonarray.add((JsonElement)new JsonPrimitive(resourcelocation.toString()));
                }
                object.add("spell_list", (JsonElement)jsonarray);
            } else if (function.elementType != ElementType.NONE) {
                object.addProperty("element_type", function.elementType.func_176610_l());
            }
        }

        public RandomSpell deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            ArrayList list = Lists.newArrayList();
            if (object.has("spell_list")) {
                for (JsonElement jsonelement : JSONUtils.func_151214_t((JsonObject)object, (String)"spell_list")) {
                    String s = JSONUtils.func_151206_a((JsonElement)jsonelement, (String)"spell");
                    Spell spell = (Spell)Spell.REGISTRY.getValue(new ResourceLocation(s));
                    if (spell == null) {
                        throw new JsonSyntaxException("Unknown spell '" + s + "'");
                    }
                    list.add(spell);
                }
                return new RandomSpell(conditionsIn, list);
            }
            if (object.has("element_type")) {
                return new RandomSpell(conditionsIn, ElementType.byName(JSONUtils.func_151200_h((JsonObject)object, (String)"element_type")));
            }
            return new RandomSpell(conditionsIn, list);
        }
    }
}

