/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.rune;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.nbt.NBTHelper;
import sirttas.elementalcraft.property.ECProperties;

public class RuneItem
extends ECItem {
    public static final String NAME = "rune";

    public RuneItem() {
        super(ECProperties.Items.ITEM_UNSTACKABLE);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        IRuneHandler handler = BlockEntityHelper.getRuneHandlerAt((IWorldReader)world, pos);
        Rune rune = RuneItem.getRune(stack);
        if (rune != null && rune.canUpgrade((IWorldReader)world, pos, handler)) {
            handler.addRune(rune);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.func_184611_a(context.func_221531_n(), ItemStack.field_190927_a);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static Rune getRune(ItemStack stack) {
        CompoundNBT tag = NBTHelper.getECTag(stack);
        if (tag != null) {
            return (Rune)ElementalCraftApi.RUNE_MANAGER.get(new ResourceLocation(tag.func_74779_i(NAME)));
        }
        return null;
    }

    public ItemStack getRuneStack(Rune rune) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        NBTHelper.getOrCreateECTag(stack).func_74778_a(NAME, rune.getId().toString());
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Rune rune = RuneItem.getRune(stack);
        if (rune != null) {
            rune.addInformation(tooltip);
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        Rune rune = RuneItem.getRune(stack);
        if (rune != null) {
            return rune.getDisplayName();
        }
        return super.func_200295_i(stack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ElementalCraftApi.RUNE_MANAGER.getData().forEach((id, rune) -> items.add((Object)this.getRuneStack((Rune)rune)));
        }
    }
}

