/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.holder;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.source.ISourceInteractable;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.holder.AbstractElementHolderItem;

public class PureElementHolderItem
extends AbstractElementHolderItem
implements ISourceInteractable {
    public static final String NAME = "pure_element_holder";

    public PureElementHolderItem() {
        super((Integer)ECConfig.COMMON.pureElementHolderCapacity.get(), (Integer)ECConfig.COMMON.pureElementHolderTransferAmount.get());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        ElementStorage storage = new ElementStorage(stack);
        if (nbt != null && nbt.func_74764_b("Parent")) {
            storage.deserializeNBT(nbt.func_74775_l("Parent"));
        }
        return CapabilityElementStorage.createProvider(storage);
    }

    @Override
    public IElementStorage getElementStorage(ItemStack stack) {
        return (IElementStorage)CapabilityElementStorage.get((ICapabilityProvider)stack).orElse((Object)new ElementStorage(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ElementType.ALL_VALID.forEach(elementType -> tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.elementalcraft.element_type_percent_full", new Object[]{elementType.getDisplayName(), ItemStack.field_111284_a.format(this.getElementStorage(stack).getElementAmount((ElementType)elementType) * 100 / this.elementCapacity)}).func_240699_a_(TextFormatting.GREEN)));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack full = new ItemStack((IItemProvider)this);
            IElementStorage storage = this.getElementStorage(full);
            ElementType.ALL_VALID.forEach(elementType -> storage.insertElement(this.elementCapacity, (ElementType)elementType, false));
            items.add((Object)new ItemStack((IItemProvider)this));
            items.add((Object)full);
        }
    }

    @Override
    protected ElementType getElementType(IElementStorage target, BlockState blockstate) {
        if (blockstate.func_235901_b_(ElementType.STATE_PROPERTY)) {
            return ElementType.getElementType(blockstate);
        }
        if (target instanceof IElementTypeProvider) {
            return ((IElementTypeProvider)((Object)target)).getElementType();
        }
        return ElementType.NONE;
    }

    private class ElementStorage
    implements IElementStorage,
    INBTSerializable<CompoundNBT> {
        private final ItemStack stack;
        private final Map<ElementType, Integer> amounts = new EnumMap<ElementType, Integer>(ElementType.class);

        public ElementStorage(ItemStack stack) {
            this.stack = stack;
            ElementType.ALL_VALID.forEach(type -> this.amounts.put((ElementType)type, 0));
        }

        @Override
        public boolean usableInInventory() {
            return true;
        }

        @Override
        public int getElementAmount(ElementType type) {
            this.refresh();
            return this.amounts.getOrDefault(type, 0);
        }

        @Override
        public int getElementCapacity(ElementType type) {
            return PureElementHolderItem.this.elementCapacity;
        }

        @Override
        public int insertElement(int count, ElementType type, boolean simulate) {
            int amount = this.getElementAmount(type);
            int newCount = Math.min(amount + count, PureElementHolderItem.this.elementCapacity);
            int ret = count - newCount + amount;
            if (!simulate) {
                this.amounts.put(type, newCount);
                this.updateAmount();
            }
            return ret;
        }

        @Override
        public int extractElement(int count, ElementType type, boolean simulate) {
            int amount = this.getElementAmount(type);
            int newCount = Math.max(amount - count, 0);
            int ret = amount - newCount;
            if (!simulate) {
                this.amounts.put(type, newCount);
                this.updateAmount();
            }
            return ret;
        }

        private void refresh() {
            this.deserializeNBT(this.stack.func_77978_p());
        }

        private void updateAmount() {
            this.serializeNBT(this.stack.func_196082_o());
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT compound = new CompoundNBT();
            this.serializeNBT(compound);
            return compound;
        }

        private void serializeNBT(CompoundNBT compound) {
            this.amounts.forEach((elementType, amount) -> compound.func_74768_a(elementType.func_176610_l(), amount.intValue()));
        }

        public void deserializeNBT(CompoundNBT compound) {
            this.amounts.replaceAll((elementType, amount) -> {
                if (compound != null && compound.func_74764_b(elementType.func_176610_l())) {
                    return compound.func_74762_e(elementType.func_176610_l());
                }
                return 0;
            });
        }
    }
}

