/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.holder;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.StaticElementStorage;
import sirttas.elementalcraft.api.source.ISourceInteractable;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.holder.AbstractElementHolderItem;

public class ElementHolderItem
extends AbstractElementHolderItem
implements ISourceInteractable,
IElementTypeProvider {
    public static final String NAME = "element_holder";
    public static final String NAME_FIRE = "element_holder_fire";
    public static final String NAME_WATER = "element_holder_water";
    public static final String NAME_EARTH = "element_holder_earth";
    public static final String NAME_AIR = "element_holder_air";
    private final ElementType elementType;

    public ElementHolderItem(ElementType elementType) {
        super((Integer)ECConfig.COMMON.elementHolderCapacity.get(), (Integer)ECConfig.COMMON.elementHolderTransferAmount.get());
        this.elementType = elementType;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    protected ElementType getElementType(IElementStorage target, BlockState blockstate) {
        return this.elementType;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        ElementStorage storage = new ElementStorage(stack);
        if (nbt != null && nbt.func_74764_b("Parent")) {
            storage.deserializeNBT(nbt.func_74775_l("Parent"));
        }
        return CapabilityElementStorage.createProvider(storage);
    }

    @Override
    public ISingleElementStorage getElementStorage(ItemStack stack) {
        return (ISingleElementStorage)CapabilityElementStorage.get((ICapabilityProvider)stack).orElse((Object)new StaticElementStorage(this.elementType, 0));
    }

    @Override
    protected boolean isValidSource(BlockState state) {
        return super.isValidSource(state) && ElementType.getElementType(state) == this.elementType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.elementalcraft.percent_full", new Object[]{ItemStack.field_111284_a.format(this.getElementStorage(stack).getElementAmount() * 100 / this.elementCapacity)}).func_240699_a_(TextFormatting.GREEN));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack full = new ItemStack((IItemProvider)this);
            ISingleElementStorage storage = this.getElementStorage(full);
            storage.insertElement(this.elementCapacity, false);
            items.add((Object)new ItemStack((IItemProvider)this));
            items.add((Object)full);
        }
    }

    public int getDamage(ItemStack stack) {
        return 1000 * (this.elementCapacity - this.getElementStorage(stack).getElementAmount()) / this.elementCapacity;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1000;
    }

    public boolean func_77645_m() {
        return true;
    }

    private class ElementStorage
    extends StaticElementStorage {
        private final ItemStack stack;

        public ElementStorage(ItemStack stack) {
            super(ElementHolderItem.this.elementType, ElementHolderItem.this.elementCapacity);
            this.stack = stack;
        }

        @Override
        public boolean usableInInventory() {
            return true;
        }

        @Override
        public int getElementAmount() {
            this.refresh();
            return super.getElementAmount();
        }

        @Override
        public int insertElement(int count, ElementType type, boolean simulate) {
            this.refresh();
            int value = super.insertElement(count, type, simulate);
            this.updateAmount();
            return value;
        }

        @Override
        public int extractElement(int count, ElementType type, boolean simulate) {
            this.refresh();
            int value = super.extractElement(count, type, simulate);
            this.updateAmount();
            return value;
        }

        private void refresh() {
            CompoundNBT tag = this.stack.func_77978_p();
            if (tag != null && tag.func_74764_b("element_amount")) {
                this.elementAmount = tag.func_74762_e("element_amount");
            }
        }

        private void updateAmount() {
            this.stack.func_196082_o().func_74768_a("element_amount", this.elementAmount);
        }
    }
}

