/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.inventory;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;

public class ECInventoryHelper {
    private ECInventoryHelper() {
    }

    public static IItemHandler getItemHandlerAt(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nullable Direction side) {
        return BlockEntityHelper.getTileEntity(world, pos).map(t -> (IItemHandler)t.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).orElseGet(() -> {
            if (t instanceof ISidedInventory && side != null) {
                return new SidedInvWrapper((ISidedInventory)t, side);
            }
            if (t instanceof IInventory) {
                return new InvWrapper((IInventory)t);
            }
            return EmptyHandler.INSTANCE;
        })).orElse(EmptyHandler.INSTANCE);
    }

    public static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean stackEqualCount(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && stack1.func_190916_E() == stack2.func_190916_E();
    }

    public static int getSlotFor(IInventory inv, ItemStack stack) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack current = inv.func_70301_a(i);
            if (current.func_190926_b() || !ECInventoryHelper.stackEqualExact(stack, current)) continue;
            return i;
        }
        return -1;
    }

    public static int getItemCount(IInventory inv) {
        return (int)IntStream.range(0, inv.func_70302_i_()).filter(i -> !inv.func_70301_a(i).func_190926_b()).count();
    }

    public static boolean isEmpty(IItemHandler targetInv) {
        for (int i = 0; i < targetInv.getSlots(); ++i) {
            if (targetInv.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

