/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.spelldesk;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import sirttas.elementalcraft.inventory.container.AbstractECContainer;
import sirttas.elementalcraft.inventory.container.ECContainers;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.recipe.SpellCraftRecipe;
import sirttas.elementalcraft.tag.ECTags;

public class SpellDeskContainer
extends AbstractECContainer {
    private final IInventory input;
    private final IInventory output;
    private final IWorldPosCallable worldPosCallable;

    public SpellDeskContainer(int id, PlayerInventory player) {
        this(id, player, IWorldPosCallable.field_221489_a);
    }

    public SpellDeskContainer(int id, PlayerInventory player, IWorldPosCallable worldPosCallable) {
        super(ECContainers.SPELL_DESK, id);
        this.worldPosCallable = worldPosCallable;
        this.input = new CraftingInventory((Container)this, 3, 1);
        this.output = new Inventory(6);
        this.func_75146_a(new InputSlot(0, 32, 35, s -> s.func_77973_b() == ECItems.SCROLL_PAPER));
        this.func_75146_a(new InputSlot(1, 23, 53, s -> Tags.Items.GEMS.func_230235_a_((Object)s.func_77973_b())));
        this.func_75146_a(new InputSlot(2, 41, 53, s -> ECTags.Items.CRYSTALS.func_230235_a_((Object)s.func_77973_b())));
        this.func_75146_a(new OutputSlot(0, 108, 35));
        this.func_75146_a(new OutputSlot(1, 126, 35));
        this.func_75146_a(new OutputSlot(2, 144, 35));
        this.func_75146_a(new OutputSlot(3, 108, 53));
        this.func_75146_a(new OutputSlot(4, 126, 53));
        this.func_75146_a(new OutputSlot(5, 144, 53));
        this.addPlayerSlots(player, 84);
    }

    public static SpellDeskContainer create(int id, PlayerInventory inventory, IWorldPosCallable worldPosCallable) {
        return new SpellDeskContainer(id, inventory, worldPosCallable);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            ItemStack stack = slotStack.func_77946_l();
            if (index < 3) {
                if (!this.func_75135_a(slotStack, 9, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (index < 9) {
                    if (!this.func_75135_a(slotStack.func_77946_l(), 9, this.field_75151_b.size(), true)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_190901_a(player, slotStack);
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(slotStack, 0, 3, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private void updateOutput(World world) {
        List stacks = world.func_199532_z().func_215370_b(SpellCraftRecipe.TYPE, this.input, world).stream().limit(6L).map(r -> r.func_77572_b(this.input)).collect(Collectors.toList());
        this.output.func_174888_l();
        for (int i = 0; i < stacks.size(); ++i) {
            this.output.func_70299_a(i, (ItemStack)stacks.get(i));
        }
        this.func_75142_b();
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.worldPosCallable.func_221486_a((world, pos) -> this.updateOutput((World)world));
    }

    @Override
    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.worldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(playerIn, (World)world, this.input));
    }

    private class InputSlot
    extends Slot {
        private final Predicate<ItemStack> predicate;

        public InputSlot(int index, int xPosition, int yPosition, Predicate<ItemStack> predicate) {
            super(SpellDeskContainer.this.input, index, xPosition, yPosition);
            this.predicate = predicate;
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.predicate.test(stack);
        }
    }

    private class OutputSlot
    extends Slot {
        public OutputSlot(int index, int xPosition, int yPosition) {
            super(SpellDeskContainer.this.output, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            ItemStack result = stack.func_77946_l();
            this.func_75208_c(result);
            for (int i = 0; i < SpellDeskContainer.this.input.func_70302_i_(); ++i) {
                SpellDeskContainer.this.input.func_70298_a(i, 1);
            }
            SpellDeskContainer.this.updateOutput(player.field_70170_p);
            return result;
        }
    }
}

