/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.RandomUtils;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.block.entity.AbstractECTickableBlockEntity;
import sirttas.elementalcraft.block.source.SourceElementStorage;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.particle.ParticleHelper;

public class SourceBlockEntity
extends AbstractECTickableBlockEntity {
    @ObjectHolder(value="elementalcraft:source")
    public static final TileEntityType<SourceBlockEntity> TYPE = null;
    private final SourceElementStorage elementStorage;
    private int recoverRate;

    public SourceBlockEntity() {
        super(TYPE);
        this.elementStorage = new SourceElementStorage(RandomUtils.nextInt((int)((Integer)ECConfig.COMMON.sourceCapacityMin.get()), (int)((Integer)ECConfig.COMMON.sourceCapacityMax.get())), this::func_70296_d);
        this.recoverRate = (Integer)ECConfig.COMMON.sourceRecoverRate.get();
    }

    public SourceBlockEntity(ElementType elementType) {
        this();
        this.elementStorage.setElementType(elementType);
    }

    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    @Override
    public void func_73660_a() {
        if (this.elementStorage.getElementType() == ElementType.NONE) {
            this.elementStorage.setElementType(ElementType.getElementType(this.func_195044_w()));
        }
        if (this.elementStorage.isExhausted()) {
            this.elementStorage.insertElement(this.recoverRate, false);
        }
        this.addParticle(this.field_145850_b.field_73012_v);
        super.func_73660_a();
    }

    private void addParticle(Random rand) {
        if (this.field_145850_b.field_72995_K && rand.nextFloat() < 0.2f) {
            if (this.elementStorage.isExhausted()) {
                ParticleHelper.createExhaustedSourceParticle(this.elementStorage.getElementType(), this.field_145850_b, Vector3d.func_237489_a_((Vector3i)this.field_174879_c), rand);
            } else {
                ParticleHelper.createSourceParticle(this.elementStorage.getElementType(), this.field_145850_b, Vector3d.func_237489_a_((Vector3i)this.field_174879_c), rand);
            }
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("element_storage")) {
            this.elementStorage.deserializeNBT(compound.func_74775_l("element_storage"));
        }
        this.recoverRate = compound.func_74762_e("recover_rate");
        this.elementStorage.setExhausted(compound.func_74767_n("exhausted"));
        if (this.recoverRate <= 10) {
            this.recoverRate = (Integer)ECConfig.COMMON.sourceRecoverRate.get();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("element_storage", (INBT)this.elementStorage.serializeNBT());
        compound.func_74768_a("recover_rate", this.recoverRate);
        compound.func_74757_a("exhausted", this.elementStorage.isExhausted());
        return compound;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY) {
            return LazyOptional.of((NonNullSupplier)(this.elementStorage != null ? () -> this.elementStorage : null)).cast();
        }
        return super.getCapability(cap, side);
    }
}

