/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.sorter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.block.entity.AbstractECTickableBlockEntity;
import sirttas.elementalcraft.block.sorter.ISorterBlock;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.inventory.ECInventoryHelper;

public class SorterBlockEntity
extends AbstractECTickableBlockEntity {
    @ObjectHolder(value="elementalcraft:sorter")
    public static final TileEntityType<SorterBlockEntity> TYPE = null;
    private List<ItemStack> stacks = Lists.newArrayList();
    private int index = 0;
    private int tick = 0;
    private boolean alwaysInsert = false;

    public SorterBlockEntity() {
        super(TYPE);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ++this.tick;
            if (this.tick > (Integer)ECConfig.COMMON.sorterCooldown.get()) {
                if (!this.isPowered()) {
                    this.transfer();
                }
                this.tick = 0;
            }
        }
    }

    public ActionResultType addStack(ItemStack stack) {
        if (!this.stacks.isEmpty() && stack.func_190926_b()) {
            this.stacks.clear();
            this.index = 0;
            this.func_70296_d();
            return ActionResultType.SUCCESS;
        }
        if (this.stacks.size() < (Integer)ECConfig.COMMON.sorterMaxItem.get()) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            this.stacks.add(copy);
            this.func_70296_d();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public List<ItemStack> getStacks() {
        return ImmutableList.copyOf(this.stacks);
    }

    public int getIndex() {
        return this.index;
    }

    private void transfer() {
        block4: {
            IItemHandler targetInv;
            IItemHandler sourceInv;
            block3: {
                BlockState state = this.func_195044_w();
                Direction source = (Direction)state.func_177229_b((Property)ISorterBlock.SOURCE);
                Direction target = (Direction)state.func_177229_b((Property)ISorterBlock.TARGET);
                sourceInv = ECInventoryHelper.getItemHandlerAt((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(source), source.func_176734_d());
                targetInv = ECInventoryHelper.getItemHandlerAt((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(target), target.func_176734_d());
                if (!this.stacks.isEmpty()) break block3;
                for (int i = 0; i < sourceInv.getSlots(); ++i) {
                    ItemStack stack = sourceInv.getStackInSlot(i).func_77946_l();
                    stack.func_190920_e(1);
                    if (stack.func_190926_b() || !ItemHandlerHelper.insertItem((IItemHandler)targetInv, (ItemStack)stack, (boolean)true).func_190926_b()) continue;
                    this.doTransfer(sourceInv, targetInv, i, stack);
                    return;
                }
                break block4;
            }
            if (this.index <= 0 && !ECInventoryHelper.isEmpty(targetInv) && !this.alwaysInsert) break block4;
            ItemStack stack = this.stacks.get(this.index).func_77946_l();
            for (int i = 0; i < sourceInv.getSlots(); ++i) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)sourceInv.getStackInSlot(i)) || !ItemHandlerHelper.insertItem((IItemHandler)targetInv, (ItemStack)stack, (boolean)true).func_190926_b()) continue;
                this.doTransfer(sourceInv, targetInv, i, stack);
                ++this.index;
                if (this.index >= this.stacks.size()) {
                    this.index = 0;
                }
                return;
            }
        }
    }

    private void doTransfer(IItemHandler sourceInv, IItemHandler targetInv, int i, ItemStack stack) {
        sourceInv.extractItem(i, 1, false);
        ItemHandlerHelper.insertItem((IItemHandler)targetInv, (ItemStack)stack, (boolean)false);
        this.func_70296_d();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.readStacks(compound.func_150295_c("stacks", 10));
        this.index = compound.func_74762_e("index");
        if (this.index > this.stacks.size()) {
            this.index = 0;
        }
        this.alwaysInsert = compound.func_74767_n("always_insert");
    }

    private void readStacks(ListNBT listNbt) {
        this.stacks.clear();
        for (int i = 0; i < listNbt.size(); ++i) {
            ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)listNbt.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.stacks.add(itemstack);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("stacks", (INBT)this.writeStacks());
        compound.func_74768_a("index", this.index);
        compound.func_74757_a("always_insert", this.alwaysInsert);
        return compound;
    }

    private ListNBT writeStacks() {
        ListNBT listnbt = new ListNBT();
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            listnbt.add((Object)itemstack.func_77955_b(new CompoundNBT()));
        }
        return listnbt;
    }
}

