/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.solarsynthesizer;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.ForgeHooksClient;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.block.entity.renderer.AbstractECRenderer;
import sirttas.elementalcraft.block.solarsynthesizer.SolarSynthesizerBlockEntity;

public class SolarSynthesizerRenderer
extends AbstractECRenderer<SolarSynthesizerBlockEntity> {
    public static final RenderMaterial BEAM = ForgeHooksClient.getBlockMaterial((ResourceLocation)ElementalCraft.createRL("effect/solar_synthesizer_beam"));
    public static final ResourceLocation LENSE_LOCATION = ElementalCraft.createRL("block/solar_synthesizer_lense");
    private IBakedModel lenseModel;

    public SolarSynthesizerRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(SolarSynthesizerBlockEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        ItemStack stack = te.getInventory().func_70301_a(0);
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.lenseModel == null) {
            this.lenseModel = minecraft.func_209506_al().getModel(LENSE_LOCATION);
        }
        this.renderRunes(matrixStack, buffer, te.getRuneHandler(), this.getAngle(partialTicks), light, overlay);
        if (!stack.func_190926_b()) {
            ElementType elementType;
            Item item = stack.func_77973_b();
            ElementType elementType2 = elementType = item instanceof IElementTypeProvider ? ((IElementTypeProvider)item).getElementType() : ElementType.NONE;
            if (elementType != ElementType.NONE) {
                float r = elementType.getRed();
                float g = elementType.getGreen();
                float b = elementType.getBlue();
                boolean isWorking = te.isWorking();
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.5, 0.90625, 0.5);
                if (isWorking) {
                    matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(te.func_145831_w().func_72929_e(partialTicks)));
                } else {
                    matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                }
                matrixStack.func_227861_a_(-0.1875, -0.03125, -0.1875);
                minecraft.func_175602_ab().func_175019_b().renderModel(matrixStack.func_227866_c_(), buffer.getBuffer(RenderType.func_228645_f_()), te.func_195044_w(), this.lenseModel, r, g, b, light, overlay, this.getModelData(this.lenseModel, te));
                matrixStack.func_227865_b_();
                if (isWorking) {
                    Vector3d beamVect = Vector3d.func_237489_a_((Vector3i)te.func_174877_v()).func_178788_d(minecraft.func_175598_ae().field_217783_c.func_216785_c()).func_216372_d(1.0, 0.0, 1.0).func_72432_b();
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_(0.5, 0.5, 0.5);
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)Math.acos(beamVect.field_72449_c * (double)(beamVect.field_72450_a > 0.0 ? 1 : -1))));
                    matrixStack.func_227862_a_(0.006f, 0.006f, 0.006f);
                    this.renderIcon(matrixStack, buffer, -21.0f, 38.0f, BEAM, 42, -76, r, g, b, light, overlay);
                    matrixStack.func_227865_b_();
                }
            }
        }
    }
}

