/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.grove;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.tag.ECTags;

public class GroveShrineBlockEntity
extends AbstractShrineBlockEntity {
    @ObjectHolder(value="elementalcraft:groveshrine")
    public static final TileEntityType<GroveShrineBlockEntity> TYPE = null;
    private static final AbstractShrineBlockEntity.Properties PROPERTIES = AbstractShrineBlockEntity.Properties.create(ElementType.WATER).periode((Double)ECConfig.COMMON.groveShrinePeriode.get()).consumeAmount((Integer)ECConfig.COMMON.groveShrineConsumeAmount.get()).range(((Integer)ECConfig.COMMON.groveShrineRange.get()).intValue());

    public GroveShrineBlockEntity() {
        super(TYPE, PROPERTIES);
    }

    private Optional<BlockPos> findGrass() {
        int range = this.getIntegerRange();
        List positions = IntStream.range(-range, range + 1).mapToObj(x -> IntStream.range(-range, range + 1).mapToObj(z -> IntStream.range(-1, 3).mapToObj(y -> new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z)))).flatMap(s -> s.flatMap(s2 -> s2)).filter(this::canPlant).map(BlockPos::func_177984_a).collect(Collectors.toList());
        return positions.isEmpty() ? Optional.empty() : Optional.of(positions.get(this.field_145850_b.field_73012_v.nextInt(positions.size())));
    }

    private boolean canPlant(BlockPos pos) {
        BlockPos up = pos.func_177984_a();
        return this.field_145850_b.func_180495_p(pos).func_177230_c() == Blocks.field_196658_i && this.field_145850_b.func_180495_p(up).isAir((IBlockReader)this.field_145850_b, up);
    }

    @Override
    public AxisAlignedBB getRangeBoundingBox() {
        int range = this.getIntegerRange();
        return new AxisAlignedBB(this.func_174877_v()).func_72314_b((double)range, 0.0, (double)range).func_72321_a(0.0, -1.0, 0.0).func_72321_a(0.0, 1.0, 0.0);
    }

    @Override
    protected boolean doTick() {
        if (this.field_145850_b instanceof ServerWorld) {
            return this.findGrass().map(p -> {
                BlockItem item = this.findFlower();
                item.func_195942_a((BlockItemUseContext)new DirectionalPlaceContext(this.field_145850_b, p, Direction.DOWN, new ItemStack((IItemProvider)item), Direction.UP));
                this.field_145850_b.func_217379_c(2005, p, 0);
                return true;
            }).orElse(false);
        }
        return false;
    }

    private BlockItem findFlower() {
        List flowers = (this.hasUpgrade((ShrineUpgrade)ShrineUpgrades.MYSTICAL_GROVE.get()) ? ECTags.Items.MYSTICAL_GROVE_FLOWERS.func_230236_b_().stream() : ECTags.Items.GROVE_SHRINE_FLOWERS.func_230236_b_().stream().filter(item -> !ECTags.Items.GROVE_SHRINE_BLACKLIST.func_230235_a_(item))).filter(BlockItem.class::isInstance).map(BlockItem.class::cast).collect(Collectors.toList());
        return (BlockItem)flowers.get(this.field_145850_b.field_73012_v.nextInt(flowers.size()));
    }
}

