/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser.pedestal;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.pipe.IPipeConnectedBlock;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalBlockEntity;

public class PedestalBlock
extends AbstractECContainerBlock
implements IElementTypeProvider,
IPipeConnectedBlock {
    private static final VoxelShape BASE_1 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape BASE_2 = Block.func_208617_a((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
    private static final VoxelShape BASE_3 = Block.func_208617_a((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape CONNECTOR_NORTH = Block.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)2.0);
    private static final VoxelShape CONNECTOR_SOUTH = Block.func_208617_a((double)7.0, (double)7.0, (double)14.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape CONNECTOR_WEST = Block.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)2.0, (double)9.0, (double)9.0);
    private static final VoxelShape CONNECTOR_EAST = Block.func_208617_a((double)14.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape BASE = VoxelShapes.func_216384_a((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, BASE_3});
    private static final VoxelShape AIR = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), (VoxelShape[])new VoxelShape[]{BASE_2, BASE_3});
    private static final VoxelShape EARTH = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)4.0, (double)3.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)3.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0)});
    public static final String NAME = "pedestal";
    public static final String NAME_FIRE = "pedestal_fire";
    public static final String NAME_WATER = "pedestal_water";
    public static final String NAME_EARTH = "pedestal_earth";
    public static final String NAME_AIR = "pedestal_air";
    private ElementType elementType;

    public PedestalBlock(ElementType type) {
        this.elementType = type;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return this.getElementType() != ElementType.NONE;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        switch (this.getElementType()) {
            case AIR: {
                return PedestalBlockEntity.createAir();
            }
            case EARTH: {
                return PedestalBlockEntity.createEarth();
            }
            case FIRE: {
                return PedestalBlockEntity.createFire();
            }
            case WATER: {
                return PedestalBlockEntity.createWater();
            }
        }
        return null;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return this.onSingleSlotActivated(world, pos, player, hand);
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = this.getBaseShape();
        if (Boolean.TRUE.equals(state.func_177229_b((Property)NORTH))) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CONNECTOR_NORTH);
        }
        if (Boolean.TRUE.equals(state.func_177229_b((Property)SOUTH))) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CONNECTOR_SOUTH);
        }
        if (Boolean.TRUE.equals(state.func_177229_b((Property)EAST))) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CONNECTOR_EAST);
        }
        if (Boolean.TRUE.equals(state.func_177229_b((Property)WEST))) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CONNECTOR_WEST);
        }
        return shape;
    }

    private VoxelShape getBaseShape() {
        if (this.elementType == ElementType.AIR) {
            return AIR;
        }
        if (this.elementType == ElementType.EARTH) {
            return EARTH;
        }
        return BASE;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{NORTH, SOUTH, EAST, WEST});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.doGetStateForPlacement((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    @Deprecated
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.doUpdatePostPlacement(stateIn, (IBlockReader)worldIn, currentPos, facing);
    }
}

