/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.extensions.IForgeBlock;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.pipe.IElementPipe;

public interface IPipeConnectedBlock
extends IForgeBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    public static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    public static final BooleanProperty SOUTH = BlockStateProperties.field_208153_F;
    public static final BooleanProperty WEST = BlockStateProperties.field_208154_G;

    default public BlockState doGetStateForPlacement(IBlockReader world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.getBlock().func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(world, pos, Direction.NORTH)))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(world, pos, Direction.SOUTH)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(world, pos, Direction.EAST)))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(world, pos, Direction.WEST)));
    }

    default public BlockState doUpdatePostPlacement(BlockState stateIn, IBlockReader world, BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return (BlockState)stateIn.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(world, pos, Direction.NORTH)));
            }
            case SOUTH: {
                return (BlockState)stateIn.func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(world, pos, Direction.SOUTH)));
            }
            case EAST: {
                return (BlockState)stateIn.func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(world, pos, Direction.WEST)));
            }
            case WEST: {
                return (BlockState)stateIn.func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(world, pos, Direction.EAST)));
            }
        }
        return stateIn;
    }

    public static boolean isConnectable(IBlockReader world, BlockPos from, Direction face) {
        IElementPipe entity = BlockEntityHelper.getTileEntityAs(world, from.func_177972_a(face), IElementPipe.class).orElse(null);
        if (entity != null) {
            IElementPipe.ConnectionType connection = entity.getConection(face);
            return connection.isConnected() || connection == IElementPipe.ConnectionType.NONE;
        }
        return false;
    }
}

