/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.renderer.AbstractECRenderer;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.IElementPipe;

public class ElementPipeRenderer
extends AbstractECRenderer<ElementPipeBlockEntity> {
    public static final ResourceLocation SIDE_LOCATION = ElementalCraft.createRL("block/elementpipe_side");
    public static final ResourceLocation EXTRACT_LOCATION = ElementalCraft.createRL("block/elementpipe_extract");
    public static final ResourceLocation PRIORITY_LOCATION = ElementalCraft.createRL("block/elementpipe_priority");
    private static final AxisAlignedBB BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private IBakedModel sideModel;
    private IBakedModel extractModel;
    private IBakedModel prioritytModel;

    public ElementPipeRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(ElementPipeBlockEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        boolean showCover;
        BlockState coverState = te.getCoverState();
        boolean bl = showCover = coverState != null && !coverState.func_196958_f();
        if (this.sideModel == null || this.extractModel == null || this.prioritytModel == null) {
            ModelManager modelManager = Minecraft.func_71410_x().func_209506_al();
            this.sideModel = modelManager.getModel(SIDE_LOCATION);
            this.extractModel = modelManager.getModel(EXTRACT_LOCATION);
            this.prioritytModel = modelManager.getModel(PRIORITY_LOCATION);
        }
        if (showCover && ElementPipeBlock.showCover(te.func_195044_w(), (PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            this.renderBlock(coverState, matrixStack, buffer, combinedLightIn, combinedOverlayIn, ModelDataManager.getModelData((World)te.func_145831_w(), (BlockPos)te.func_174877_v()));
        } else {
            this.renderPipes(te, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
            if (showCover) {
                this.renderBlock((BlockState)te.func_195044_w().func_206870_a(ElementPipeBlock.COVER, (Comparable)((Object)ElementPipeBlock.CoverType.NONE)), matrixStack, buffer, combinedLightIn, combinedOverlayIn, ModelDataManager.getModelData((World)te.func_145831_w(), (BlockPos)te.func_174877_v()));
                WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)buffer.getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)BOX, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    private void renderPipes(ElementPipeBlockEntity te, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        Stream.of(Direction.values()).forEach(d -> this.renderSide(te, (Direction)d, matrixStack, buffer, light, overlay));
        matrixStack.func_227865_b_();
    }

    private void renderSide(ElementPipeBlockEntity te, Direction side, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        IElementPipe.ConnectionType connection = te.getConection(side);
        if (connection.isConnected()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(side.func_229384_a_());
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            this.renderModel(this.sideModel, matrixStack, buffer, te, light, overlay);
            if (connection == IElementPipe.ConnectionType.EXTRACT) {
                this.renderModel(this.extractModel, matrixStack, buffer, te, light, overlay);
            }
            if (te.isPriority(side)) {
                this.renderModel(this.prioritytModel, matrixStack, buffer, te, light, overlay);
            }
            matrixStack.func_227865_b_();
        }
    }
}

