/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.block.entity.AbstractECTickableBlockEntity;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;
import sirttas.elementalcraft.block.pipe.IElementPipe;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.ECItems;

public class ElementPipeBlockEntity
extends AbstractECTickableBlockEntity
implements IElementPipe {
    @ObjectHolder(value="elementalcraft:elementpipe")
    public static final TileEntityType<ElementPipeBlockEntity> TYPE = null;
    private final Map<Direction, IElementPipe.ConnectionType> connections = new EnumMap<Direction, IElementPipe.ConnectionType>(Direction.class);
    private final Map<Direction, Boolean> priorities = new EnumMap<Direction, Boolean>(Direction.class);
    private int transferedAmount = 0;
    private int maxTransferAmount;
    private BlockState coverState;
    private final Comparator<Map.Entry<Direction, IElementPipe.ConnectionType>> comparator;

    public ElementPipeBlockEntity() {
        this((Integer)ECConfig.COMMON.pipeTransferAmount.get());
    }

    public ElementPipeBlockEntity(int maxTransferAmount) {
        super(TYPE);
        this.maxTransferAmount = maxTransferAmount;
        this.comparator = this.creatComparator();
    }

    private Comparator<Map.Entry<Direction, IElementPipe.ConnectionType>> creatComparator() {
        Comparator cmp = (c1, c2) -> Boolean.compare(this.isPriority((Direction)c2.getKey()), this.isPriority((Direction)c1.getKey()));
        return cmp.thenComparing((c1, c2) -> ((IElementPipe.ConnectionType)((Object)((Object)c2.getValue()))).getValue() - ((IElementPipe.ConnectionType)((Object)((Object)c1.getValue()))).getValue());
    }

    private Optional<TileEntity> getAdjacentTile(Direction face) {
        return this.func_145830_o() ? BlockEntityHelper.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(face)) : Optional.empty();
    }

    @Override
    public IElementPipe.ConnectionType getConection(Direction face) {
        return this.connections.getOrDefault(face, IElementPipe.ConnectionType.NONE);
    }

    @Override
    public boolean isPriority(Direction face) {
        return Boolean.TRUE.equals(this.priorities.get(face));
    }

    private void setConection(Direction face, IElementPipe.ConnectionType type) {
        this.connections.put(face, type);
        if (type == IElementPipe.ConnectionType.DISCONNECT && this.isPriority(face)) {
            this.setPriority(face, false);
            this.dropPriorities(null, 1);
        }
        this.func_70296_d();
    }

    private void setPriority(Direction face, boolean value) {
        this.priorities.put(face, value);
        this.func_70296_d();
    }

    private void refresh(Direction face) {
        this.setConection(face, this.getAdjacentTile(face).map(tile -> {
            IElementPipe.ConnectionType connection = this.getConection(face);
            if (connection != IElementPipe.ConnectionType.NONE) {
                return connection;
            }
            if (tile instanceof ElementPipeBlockEntity) {
                return IElementPipe.ConnectionType.CONNECT;
            }
            return CapabilityElementStorage.get((ICapabilityProvider)tile, face.func_176734_d()).map(storage -> {
                if (this.canInsertInStorage((IElementStorage)storage)) {
                    return IElementPipe.ConnectionType.INSERT;
                }
                if (this.canExtractFromStorage((IElementStorage)storage)) {
                    return IElementPipe.ConnectionType.EXTRACT;
                }
                return IElementPipe.ConnectionType.NONE;
            }).orElse(IElementPipe.ConnectionType.NONE);
        }).orElse(IElementPipe.ConnectionType.NONE));
    }

    void refresh() {
        for (Direction face : Direction.values()) {
            this.refresh(face);
        }
    }

    private void transferElement(IElementStorage sender, ElementType type) {
        if (type != ElementType.NONE) {
            Path path = new Path(sender);
            path.searchReceiver(this, type, sender.extractElement(this.getRemainingAmount(), type, true)).ifPresent(receiver -> {
                int remainingAmount = path.amount - sender.transferTo((IElementStorage)receiver, type, path.amount);
                path.pipes.forEach(p -> p.transferedAmount += remainingAmount);
            });
        }
    }

    private int getRemainingAmount() {
        return this.maxTransferAmount - this.transferedAmount;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.refresh();
        this.transferedAmount = 0;
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            this.connections.entrySet().stream().filter(entry -> entry.getValue() == IElementPipe.ConnectionType.EXTRACT).sorted(this.comparator).map(Map.Entry::getKey).map(side -> this.getAdjacentTile((Direction)side).flatMap(tile -> CapabilityElementStorage.get((ICapabilityProvider)tile, side.func_176734_d()).resolve())).filter(Optional::isPresent).map(Optional::get).forEach(sender -> {
                if (sender instanceof IElementTypeProvider) {
                    this.transferElement((IElementStorage)sender, ((IElementTypeProvider)((Object)sender)).getElementType());
                }
            });
        }
    }

    public ActionResultType activatePriority(Direction face, PlayerEntity player, Hand hand) {
        boolean priority = this.isPriority(face);
        this.setPriority(face, !priority);
        if (priority) {
            this.dropPriorities(player, 1);
        } else {
            ItemStack stack = player.func_184586_b(hand);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void dropPriorities(@Nullable PlayerEntity player, int size) {
        World world = this.func_145831_w();
        if (world != null && !world.field_72995_K) {
            Vector3d vect = player != null ? player.func_213303_ch().func_72441_c(0.0, 0.25, 0.0) : Vector3d.func_237489_a_((Vector3i)this.func_174877_v());
            world.func_217376_c((Entity)new ItemEntity(world, vect.field_72450_a, vect.field_72448_b, vect.field_72449_c, new ItemStack((IItemProvider)ECItems.PIPE_PRIORITY, size)));
        }
    }

    void dropAllPriorities() {
        this.dropPriorities(null, (int)this.priorities.values().stream().filter(Boolean.TRUE::equals).count());
    }

    public ActionResultType activatePipe(Direction face) {
        return this.getAdjacentTile(face).map(tile -> {
            IElementPipe.ConnectionType connection = this.getConection(face);
            switch (connection) {
                case INSERT: {
                    if (CapabilityElementStorage.get((ICapabilityProvider)tile, face.func_176734_d()).filter(this::canExtractFromStorage).isPresent()) {
                        this.setConection(face, IElementPipe.ConnectionType.EXTRACT);
                    } else {
                        this.setConection(face, IElementPipe.ConnectionType.DISCONNECT);
                    }
                    return ActionResultType.SUCCESS;
                }
                case EXTRACT: 
                case CONNECT: {
                    this.setConection(face, IElementPipe.ConnectionType.DISCONNECT);
                    if (tile instanceof ElementPipeBlockEntity) {
                        ((ElementPipeBlockEntity)tile).setConection(face.func_176734_d(), IElementPipe.ConnectionType.DISCONNECT);
                    }
                    return ActionResultType.SUCCESS;
                }
                case DISCONNECT: {
                    LazyOptional<IElementStorage> cap = CapabilityElementStorage.get((ICapabilityProvider)tile, face.func_176734_d());
                    if (cap.filter(this::canInsertInStorage).isPresent()) {
                        this.setConection(face, IElementPipe.ConnectionType.INSERT);
                    } else if (cap.filter(this::canExtractFromStorage).isPresent()) {
                        this.setConection(face, IElementPipe.ConnectionType.EXTRACT);
                    } else if (tile instanceof ElementPipeBlockEntity) {
                        this.setConection(face, IElementPipe.ConnectionType.CONNECT);
                        ((ElementPipeBlockEntity)tile).setConection(face.func_176734_d(), IElementPipe.ConnectionType.CONNECT);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
            return ActionResultType.PASS;
        }).orElse(ActionResultType.PASS);
    }

    private boolean canInsertInStorage(IElementStorage storage) {
        return ElementType.ALL_VALID.stream().anyMatch(storage::canPipeInsert);
    }

    private boolean canExtractFromStorage(IElementStorage storage) {
        return ElementType.ALL_VALID.stream().anyMatch(storage::canPipeExtract);
    }

    public ITextComponent getConnectionMessage(Direction face) {
        return this.getConection(face).getDisplayName();
    }

    public BlockState getCoverState() {
        return this.coverState;
    }

    public ActionResultType setCover(PlayerEntity player, Hand hand) {
        BlockState state;
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem && !stack.func_190926_b() && (state = ((BlockItem)item).func_179223_d().func_176223_P()) != this.coverState) {
            if (this.coverState != null) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)new ItemStack((IItemProvider)this.coverState.func_177230_c()));
            }
            this.coverState = state;
            this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)this.func_145831_w().func_180495_p(this.field_174879_c).func_206870_a(ElementPipeBlock.COVER, (Comparable)((Object)ElementPipeBlock.CoverType.COVERED)));
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        for (Direction face : Direction.values()) {
            this.setConection(face, IElementPipe.ConnectionType.fromInteger(compound.func_74762_e(face.func_176610_l())));
            this.setPriority(face, compound.func_74767_n(face.func_176610_l() + "_priority"));
        }
        this.maxTransferAmount = compound.func_74762_e("max_transfer_amount");
        this.coverState = compound.func_74764_b("cover") ? NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("cover")) : null;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.connections.forEach((k, v) -> compound.func_74768_a(k.func_176610_l(), v.getValue()));
        this.priorities.forEach((k, v) -> compound.func_74757_a(k.func_176610_l() + "_priority", v.booleanValue()));
        compound.func_74768_a("max_transfer_amount", this.maxTransferAmount);
        if (this.coverState != null) {
            compound.func_218657_a("cover", (INBT)NBTUtil.func_190009_a((BlockState)this.coverState));
        } else if (compound.func_74764_b("cover")) {
            compound.func_82580_o("cover");
        }
        return compound;
    }

    private static class Path {
        private final IElementStorage sender;
        List<ElementPipeBlockEntity> visited = Lists.newArrayListWithCapacity((int)100);
        List<ElementPipeBlockEntity> pipes = Lists.newArrayListWithCapacity((int)100);
        int amount;

        public Path(IElementStorage sender) {
            this.sender = sender;
        }

        private Optional<IElementStorage> searchReceiver(ElementPipeBlockEntity pipe, ElementType type, int lastCount) {
            int count = Math.min(lastCount, pipe.getRemainingAmount());
            if (count > 0 && !this.visited.contains(pipe)) {
                this.visited.add(pipe);
                return this.getConnectionStream(pipe).map(entry -> {
                    Direction side = (Direction)entry.getKey();
                    IElementPipe.ConnectionType connection = (IElementPipe.ConnectionType)((Object)((Object)entry.getValue()));
                    return pipe.getAdjacentTile(side).flatMap(entity -> {
                        Optional cap;
                        if (entity instanceof ElementPipeBlockEntity && connection == IElementPipe.ConnectionType.CONNECT) {
                            Optional<IElementStorage> receiver2 = this.searchReceiver((ElementPipeBlockEntity)entity, type, count);
                            if (receiver2.isPresent()) {
                                this.pipes.add(pipe);
                                return receiver2;
                            }
                        } else if (connection == IElementPipe.ConnectionType.INSERT && (cap = CapabilityElementStorage.get((ICapabilityProvider)entity, side.func_176734_d()).filter(receiver -> receiver != this.sender && receiver.canPipeInsert(type) && receiver.insertElement(count, type, true) < count)).isPresent()) {
                            this.amount = count;
                            this.pipes.add(pipe);
                            return cap;
                        }
                        return Optional.empty();
                    });
                }).filter(Optional::isPresent).map(Optional::get).findAny();
            }
            return Optional.empty();
        }

        private Stream<Map.Entry<Direction, IElementPipe.ConnectionType>> getConnectionStream(ElementPipeBlockEntity pipe) {
            return pipe.connections.entrySet().stream().filter(entry -> {
                IElementPipe.ConnectionType connection = (IElementPipe.ConnectionType)((Object)((Object)entry.getValue()));
                return connection == IElementPipe.ConnectionType.CONNECT || connection == IElementPipe.ConnectionType.INSERT;
            }).sorted(pipe.comparator);
        }
    }
}

