/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.AbstractECBlockEntityProviderBlock;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.shape.ShapeHelper;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.tag.ECTags;

public class ElementPipeBlock
extends AbstractECBlockEntityProviderBlock {
    public static final String NAME = "elementpipe";
    public static final String NAME_IMPAIRED = "elementpipe_impaired";
    public static final String NAME_IMPROVED = "elementpipe_improved";
    private static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)6.5, (double)6.5, (double)6.5, (double)9.5, (double)9.5, (double)9.5);
    private static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)6.5, (double)9.0, (double)9.0);
    private static final VoxelShape DOWN_SHAPE = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.5, (double)9.0);
    private static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)6.5);
    private static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)9.5, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape UP_SHAPE = Block.func_208617_a((double)7.0, (double)9.5, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)7.0, (double)7.0, (double)9.5, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape FRAME_SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0)}), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final List<VoxelShape> SHAPES = ImmutableList.of((Object)EAST_SHAPE, (Object)NORTH_SHAPE, (Object)WEST_SHAPE, (Object)SOUTH_SHAPE, (Object)UP_SHAPE, (Object)DOWN_SHAPE, (Object)BASE_SHAPE, (Object)FRAME_SHAPE);
    public static final EnumProperty<CoverType> COVER = EnumProperty.func_177709_a((String)"cover", CoverType.class);
    private int maxTransferAmount;

    public ElementPipeBlock(int maxTransferAmount) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_226896_b_().func_200944_c());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(COVER, (Comparable)((Object)CoverType.NONE)));
        this.maxTransferAmount = maxTransferAmount;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{COVER});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ElementPipeBlockEntity(this.maxTransferAmount);
    }

    @Deprecated
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        ((ElementPipeBlockEntity)worldIn.func_175625_s(pos)).refresh();
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        ((ElementPipeBlockEntity)worldIn.func_175625_s(pos)).refresh();
    }

    private boolean compareShapes(VoxelShape shape1, VoxelShape shape2) {
        return shape1.func_197752_a().equals((Object)shape2.func_197752_a());
    }

    private Direction getFace(VoxelShape shape, BlockRayTraceResult hit) {
        if (this.compareShapes(shape, DOWN_SHAPE)) {
            return Direction.DOWN;
        }
        if (this.compareShapes(shape, UP_SHAPE)) {
            return Direction.UP;
        }
        if (this.compareShapes(shape, NORTH_SHAPE)) {
            return Direction.NORTH;
        }
        if (this.compareShapes(shape, SOUTH_SHAPE)) {
            return Direction.SOUTH;
        }
        if (this.compareShapes(shape, WEST_SHAPE)) {
            return Direction.WEST;
        }
        if (this.compareShapes(shape, EAST_SHAPE)) {
            return Direction.EAST;
        }
        if (shape == BASE_SHAPE) {
            return hit.func_216354_b();
        }
        return null;
    }

    public static boolean showCover(BlockState state, PlayerEntity player) {
        return ElementPipeBlock.isCovered(state) && (player == null || EntityHelper.handStream(player).noneMatch(stack -> !stack.func_190926_b() && ECTags.Items.PIPE_COVER_HIDING.func_230235_a_((Object)stack.func_77973_b())));
    }

    private static boolean isCovered(BlockState state) {
        return state.func_177229_b(COVER) == CoverType.COVERED;
    }

    private boolean isRendered(VoxelShape shape, ElementPipeBlockEntity entity, BlockState state) {
        return state.func_203425_a((Block)this) && entity != null && (this.compareShapes(shape, BASE_SHAPE) || this.compareShapes(shape, DOWN_SHAPE) && entity.getConection(Direction.DOWN).isConnected() || this.compareShapes(shape, UP_SHAPE) && entity.getConection(Direction.UP).isConnected() || this.compareShapes(shape, NORTH_SHAPE) && entity.getConection(Direction.NORTH).isConnected() || this.compareShapes(shape, SOUTH_SHAPE) && entity.getConection(Direction.SOUTH).isConnected() || this.compareShapes(shape, WEST_SHAPE) && entity.getConection(Direction.WEST).isConnected() || this.compareShapes(shape, EAST_SHAPE) && entity.getConection(Direction.EAST).isConnected() || this.compareShapes(shape, FRAME_SHAPE) && state.func_177229_b(COVER) == CoverType.FRAME);
    }

    private VoxelShape getCurentShape(BlockState state, ElementPipeBlockEntity entity, PlayerEntity player) {
        VoxelShape result = VoxelShapes.func_197880_a();
        if (ElementPipeBlock.showCover(state, (PlayerEntity)(entity != null ? player : null))) {
            return VoxelShapes.func_197868_b();
        }
        for (VoxelShape shape : SHAPES) {
            if (!this.isRendered(shape, entity, state)) continue;
            result = VoxelShapes.func_197872_a((VoxelShape)result, (VoxelShape)shape);
        }
        return result;
    }

    @Override
    @Deprecated
    public BlockRenderType func_149645_b(BlockState state) {
        if (ElementPipeBlock.isCovered(state)) {
            return BlockRenderType.ENTITYBLOCK_ANIMATED;
        }
        return super.func_149645_b(state);
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        PlayerEntity player = this.getPlayer(context);
        ElementPipeBlockEntity blockEntity = ElementPipeBlock.getBlockEntity(world, pos);
        return world instanceof World && ((World)world).field_72995_K ? this.getShape(state, pos, blockEntity, Minecraft.func_71410_x().field_71476_x, player) : this.getCurentShape(state, blockEntity, player);
    }

    private PlayerEntity getPlayer(ISelectionContext context) {
        Entity entity = context.getEntity();
        return entity instanceof PlayerEntity ? (PlayerEntity)entity : ElementalCraft.PROXY.getDefaultPlayer();
    }

    public VoxelShape getShape(BlockState state, BlockPos pos, ElementPipeBlockEntity blockEntity, RayTraceResult result, PlayerEntity player) {
        if (!ElementPipeBlock.showCover(state, player) && result != null && result.func_216346_c() == RayTraceResult.Type.BLOCK && ((BlockRayTraceResult)result).func_216350_a().equals((Object)pos)) {
            Vector3d hit = result.func_216347_e();
            for (VoxelShape shape : SHAPES) {
                if (!this.isRendered(shape, blockEntity, state) || !ShapeHelper.vectorCollideWithShape(shape, pos, hit)) continue;
                return shape;
            }
        }
        return this.getCurentShape(state, blockEntity, player);
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.getCurentShape(state, ElementPipeBlock.getBlockEntity(world, pos), null);
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)world.func_175625_s(pos);
        if (pipe != null) {
            VoxelShape shape = this.getShape(state, pos, ElementPipeBlock.getBlockEntity((IBlockReader)world, pos), (RayTraceResult)hit, player);
            if (this.compareShapes(shape, FRAME_SHAPE) || state.func_177229_b(COVER) == CoverType.FRAME) {
                return pipe.setCover(player, hand);
            }
            Direction face = this.getFace(shape, hit);
            ActionResultType value = this.onShapeActivated(face, pipe, player, hand);
            if (value != ActionResultType.PASS) {
                player.func_146105_b(pipe.getConnectionMessage(face), true);
            }
            return value;
        }
        return ActionResultType.PASS;
    }

    private ActionResultType onShapeActivated(Direction face, ElementPipeBlockEntity pipe, PlayerEntity player, Hand hand) {
        if (face != null) {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_190926_b() && stack.func_77973_b() == ECItems.PIPE_PRIORITY) {
                return pipe.activatePriority(face, player, hand);
            }
            return pipe.activatePipe(face);
        }
        return ActionResultType.PASS;
    }

    @Override
    @Deprecated
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            ElementPipeBlockEntity te = (ElementPipeBlockEntity)worldIn.func_175625_s(pos);
            if (ElementPipeBlock.isCovered(state)) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack((IItemProvider)te.getCoverState().func_177230_c()));
            }
            te.dropAllPriorities();
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    private static ElementPipeBlockEntity getBlockEntity(IBlockReader world, BlockPos pos) {
        return BlockEntityHelper.getTileEntityAs(world, pos, ElementPipeBlockEntity.class).orElse(null);
    }

    public static enum CoverType implements IStringSerializable
    {
        NONE("none"),
        FRAME("frame"),
        COVERED("covered");

        public static final Codec<CoverType> CODEC;
        private final String name;

        private CoverType(String name) {
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static CoverType byName(String name) {
            for (CoverType bonusType : CoverType.values()) {
                if (!bonusType.name.equals(name)) continue;
                return bonusType;
            }
            return NONE;
        }

        static {
            CODEC = IStringSerializable.func_233023_a_(CoverType::values, CoverType::byName);
        }
    }
}

