/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.mill;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.renderer.AbstractECRenderer;
import sirttas.elementalcraft.block.instrument.mill.AirMillBlock;
import sirttas.elementalcraft.block.instrument.mill.AirMillBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class AirMillRenderer
extends AbstractECRenderer<AirMillBlockEntity> {
    public static final ResourceLocation BLADES_LOCATION = ElementalCraft.createRL("block/air_mill_blades");
    private IBakedModel bladesModel;

    public AirMillRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(AirMillBlockEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        if (this.bladesModel == null) {
            this.bladesModel = Minecraft.func_71410_x().func_209506_al().getModel(BLADES_LOCATION);
        }
        IInventory inv = te.getInventory();
        ItemStack stack = inv.func_70301_a(0);
        ItemStack stack2 = inv.func_70301_a(1);
        float tick = this.getAngle(partialTicks);
        this.renderRunes(matrixStack, buffer, te.getRuneHandler(), tick, light, overlay);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.25, 0.0);
        if (te.isRunning()) {
            matrixStack.func_227861_a_(0.5, 0.0, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-5.0f * tick));
            matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
        }
        this.renderModel(this.bladesModel, matrixStack, buffer, te, light, overlay);
        matrixStack.func_227865_b_();
        if (!stack.func_190926_b() || !stack2.func_190926_b()) {
            matrixStack.func_227861_a_(0.5, 0.3, 0.5);
            matrixStack.func_227863_a_(this.getRotation((Direction)te.func_195044_w().func_177229_b((Property)AirMillBlock.FACING)));
            matrixStack.func_227861_a_(0.0, 0.0, -0.375);
            if (!stack.func_190926_b()) {
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(tick));
                this.renderItem(stack, matrixStack, buffer, light, overlay);
                matrixStack.func_227865_b_();
            }
            if (!stack2.func_190926_b()) {
                matrixStack.func_227861_a_(0.0, 0.0, 0.75);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(tick));
                this.renderItem(stack2, matrixStack, buffer, light, overlay);
            }
        }
    }
}

