/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.evaporator;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.entity.AbstractIERBlockEntity;
import sirttas.elementalcraft.block.evaporator.EvaporatorBlock;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.inventory.SingleStackInventory;
import sirttas.elementalcraft.item.elemental.ShardItem;

public class EvaporatorBlockEntity
extends AbstractIERBlockEntity {
    @ObjectHolder(value="elementalcraft:evaporator")
    public static final TileEntityType<EvaporatorBlockEntity> TYPE = null;
    private final SingleStackInventory inventory = new SingleStackInventory(this::func_70296_d);
    private final SingleElementStorage elementStorage;
    private final RuneHandler runeHandler;

    public EvaporatorBlockEntity() {
        super(TYPE);
        this.elementStorage = new SingleElementStorage((Integer)ECConfig.COMMON.shardElementAmount.get() * 20, this::func_70296_d);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.evaporatorMaxRunes.get());
    }

    @Override
    public void func_73660_a() {
        ItemStack stack = this.inventory.func_70301_a(0);
        Item item = stack.func_77973_b();
        ElementType type = EvaporatorBlock.getShardElementType(stack);
        float extractionAmount = this.runeHandler.getTransferSpeed(((Integer)ECConfig.COMMON.evaporatorExtractionAmount.get()).intValue());
        super.func_73660_a();
        if (type != ElementType.NONE && (float)this.elementStorage.getElementAmount() <= extractionAmount) {
            this.elementStorage.insertElement(this.getShardElementAmount((ShardItem)item), type, false);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                this.inventory.func_70299_a(0, ItemStack.field_190927_a);
            }
        }
        if (this.canExtract()) {
            this.elementStorage.transferTo((IElementStorage)this.getTank(), extractionAmount, this.runeHandler.getElementPreservation());
        }
    }

    public boolean canExtract() {
        ISingleElementStorage tank = this.getTank();
        return !this.elementStorage.isEmpty() && this.func_145830_o() && tank != null && (tank.getElementAmount() < tank.getElementCapacity() || tank.getElementType() != this.elementStorage.getElementType());
    }

    private int getShardElementAmount(ShardItem item) {
        return Math.round((float)((Integer)ECConfig.COMMON.shardElementAmount.get() * item.getElementAmount()) * this.runeHandler.getElementPreservation());
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    @Override
    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }
}

