/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.evaporator;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.evaporator.EvaporatorBlockEntity;
import sirttas.elementalcraft.item.elemental.ShardItem;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.tag.ECTags;

public class EvaporatorBlock
extends AbstractECContainerBlock {
    public static final String NAME = "evaporator";
    private static final VoxelShape BASE_1 = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape BASE_2 = Block.func_208617_a((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
    private static final VoxelShape PIPE_1 = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)8.0, (double)5.0);
    private static final VoxelShape PIPE_2 = Block.func_208617_a((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)5.0);
    private static final VoxelShape PIPE_3 = Block.func_208617_a((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)8.0, (double)13.0);
    private static final VoxelShape PIPE_4 = Block.func_208617_a((double)11.0, (double)0.0, (double)11.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, PIPE_1, PIPE_2, PIPE_3, PIPE_4});

    @Override
    public EvaporatorBlockEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EvaporatorBlockEntity();
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() || EvaporatorBlock.getShardElementType(stack) != ElementType.NONE) {
            return this.onSingleSlotActivated(world, pos, player, hand);
        }
        return ActionResultType.PASS;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return BlockEntityHelper.isValidContainer(state.func_177230_c(), world, pos.func_177977_b());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        BlockEntityHelper.getTileEntityAs((IBlockReader)world, pos, EvaporatorBlockEntity.class).filter(EvaporatorBlockEntity::canExtract).ifPresent(evaporator -> ParticleHelper.createElementFlowParticle(evaporator.getElementStorage().getElementType(), world, Vector3d.func_237489_a_((Vector3i)pos.func_177977_b()), Direction.DOWN, 1, rand));
    }

    public static ElementType getShardElementType(ItemStack stack) {
        Item item;
        if (!stack.func_190926_b() && ECTags.Items.SHARDS.func_230235_a_((Object)(item = stack.func_77973_b())) && item instanceof ShardItem) {
            return ((ShardItem)item).getElementType();
        }
        return ElementType.NONE;
    }
}

