/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.event.TickHandler;

public abstract class AbstractECRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    protected AbstractECRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public Quaternion getRotation(Direction direction) {
        switch (direction) {
            case SOUTH: {
                return Vector3f.field_229181_d_.func_229187_a_(180.0f);
            }
            case WEST: {
                return Vector3f.field_229181_d_.func_229187_a_(90.0f);
            }
            case EAST: {
                return Vector3f.field_229181_d_.func_229187_a_(-90.0f);
            }
        }
        return Quaternion.field_227060_a_.func_227068_g_();
    }

    public void renderItem(ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, light, overlay, matrixStack, buffer);
    }

    public void renderBlock(BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, IModelData data) {
        Minecraft.func_71410_x().func_175602_ab().renderBlock(state, matrixStack, buffer, light, overlay, data);
    }

    public void renderBlock(BlockState state, MatrixStack matrixStack, IVertexBuilder builder, World world, BlockPos pos) {
        matrixStack.func_227860_a_();
        Minecraft.func_71410_x().func_175602_ab().renderModel(state, pos, (IBlockDisplayReader)world, matrixStack, builder, false, world.field_73012_v, ModelDataManager.getModelData((World)world, (BlockPos)pos));
        matrixStack.func_227865_b_();
    }

    public void renderRunes(MatrixStack matrixStack, IRenderTypeBuffer buffer, IRuneHandler handler, float tick, int light, int overlay) {
        int ruenCount = handler.getRuneCount();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.75, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(tick / 2.0f));
        handler.getRunes().forEach(rune -> {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f / (float)ruenCount));
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.75, 0.0, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            matrixStack.func_227862_a_(0.015625f, 0.015625f, 0.015625f);
            this.renderIcon(matrixStack, buffer, rune.getSprite(), 16, -16, light, overlay);
            matrixStack.func_227865_b_();
        });
        matrixStack.func_227865_b_();
    }

    public void renderIcon(MatrixStack matrixStack, IRenderTypeBuffer buffer, RenderMaterial renderMaterial, int width, int height, int light, int overlay) {
        this.renderIcon(matrixStack, buffer, 0.0f, 0.0f, renderMaterial, width, height, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    public void renderIcon(MatrixStack matrixStack, IRenderTypeBuffer buffer, float x, float y, RenderMaterial renderMaterial, int width, int height, float r, float g, float b, int light, int overlay) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        Matrix3f normal = matrixStack.func_227866_c_().func_227872_b_();
        IVertexBuilder builder = renderMaterial.func_229311_a_(buffer, RenderType::func_228644_e_);
        TextureAtlasSprite sprite = renderMaterial.func_229314_c_();
        builder.func_227888_a_(matrix, x, y, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_227891_b_(overlay).func_227886_a_(light).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, x + (float)width, y, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_227891_b_(overlay).func_227886_a_(light).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, x + (float)width, y + (float)height, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_227891_b_(overlay).func_227886_a_(light).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, x, y + (float)height, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_227891_b_(overlay).func_227886_a_(light).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public void renderModel(IBakedModel model, MatrixStack matrixStack, IRenderTypeBuffer buffer, BlockState state, int light, int overlay) {
        this.renderModel(model, matrixStack, buffer, state, light, overlay, (IModelData)EmptyModelData.INSTANCE);
    }

    public void renderModel(IBakedModel model, MatrixStack matrixStack, IRenderTypeBuffer buffer, T te, int light, int overlay) {
        this.renderModel(model, matrixStack, buffer, te.func_195044_w(), light, overlay, this.getModelData(model, te));
    }

    public void renderModel(IBakedModel model, MatrixStack matrixStack, IRenderTypeBuffer buffer, BlockState state, int light, int overlay, IModelData data) {
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().renderModel(matrixStack.func_227866_c_(), buffer.getBuffer(state != null ? RenderTypeLookup.func_239220_a_((BlockState)state, (boolean)false) : Atlases.func_228783_h_()), state, model, 1.0f, 1.0f, 1.0f, light, overlay, data);
    }

    public float getAngle(float partialTicks) {
        return (float)TickHandler.getTicksInGame() + partialTicks % 360.0f;
    }

    public IModelData getModelData(IBakedModel model, T te) {
        World world = te.func_145831_w();
        BlockPos pos = te.func_174877_v();
        return model.getModelData((IBlockDisplayReader)world, pos, te.func_195044_w(), ModelDataManager.getModelData((World)world, (BlockPos)pos));
    }
}

